/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.NNF;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.CollectionContainer;
import uk.ac.manchester.cs.owl.owlapi.CollectionContainerVisitor;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;

public abstract class OWLAxiomImplWithoutEntityAndAnonCaching
extends OWLObjectImplWithoutEntityAndAnonCaching
implements OWLAxiom,
CollectionContainer<OWLAnnotation> {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final List<OWLAnnotation> annotations;

    @Override
    protected int index() {
        return 2000 + this.getAxiomType().getIndex();
    }

    public OWLAxiomImplWithoutEntityAndAnonCaching(@Nonnull Collection<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(annotations, (String)"annotations cannot be null");
        this.annotations = !annotations.isEmpty() ? (annotations.size() == 1 ? Collections.singletonList(annotations.iterator().next()) : CollectionFactory.sortOptionally(annotations)) : CollectionFactory.emptyList();
    }

    public boolean isAnnotated() {
        return !this.annotations.isEmpty();
    }

    public Set<OWLAnnotation> getAnnotations() {
        if (this.annotations.isEmpty()) {
            return CollectionFactory.emptySet();
        }
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.annotations);
    }

    @Override
    public void accept(CollectionContainerVisitor<OWLAnnotation> t) {
        int size = this.annotations.size();
        for (int i = 0; i < size; ++i) {
            t.visitItem(this.annotations.get(i));
        }
    }

    public Set<OWLAnnotation> getAnnotations(OWLAnnotationProperty annotationProperty) {
        if (this.annotations.isEmpty()) {
            return CollectionFactory.emptySet();
        }
        HashSet<OWLAnnotation> result = new HashSet<OWLAnnotation>();
        for (OWLAnnotation anno : this.annotations) {
            if (!anno.getProperty().equals(annotationProperty)) continue;
            result.add(anno);
        }
        return result;
    }

    public boolean equalsIgnoreAnnotations(OWLAxiom axiom) {
        return this.getAxiomWithoutAnnotations().equals(axiom.getAxiomWithoutAnnotations());
    }

    public boolean isOfType(AxiomType<?> ... axiomTypes) {
        for (AxiomType<?> type : axiomTypes) {
            if (!this.getAxiomType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isOfType(Set<AxiomType<?>> types) {
        return types.contains(this.getAxiomType());
    }

    @Nonnull
    protected Set<OWLAnnotation> mergeAnnos(Set<OWLAnnotation> annos) {
        HashSet<OWLAnnotation> merged = new HashSet<OWLAnnotation>(annos);
        merged.addAll(this.annotations);
        return merged;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLAxiom)) {
            return false;
        }
        OWLAxiom other = (OWLAxiom)obj;
        if (other instanceof OWLAxiomImplWithoutEntityAndAnonCaching) {
            return this.annotations.equals(((OWLAxiomImplWithoutEntityAndAnonCaching)other).annotations);
        }
        return this.getAnnotations().equals(other.getAnnotations());
    }

    public OWLAxiom getNNF() {
        NNF con = new NNF((OWLDataFactory)new OWLDataFactoryImpl());
        OWLAxiom nnf = (OWLAxiom)this.accept((OWLAxiomVisitorEx)con);
        return (OWLAxiom)OWLAPIPreconditions.verifyNotNull((Object)nnf);
    }

    @Override
    @Nonnull
    public Set<OWLEntity> getSignature() {
        Set<OWLEntity> signature = super.getSignature();
        OWLAxiomImplWithoutEntityAndAnonCaching.addEntitiesFromAnnotationsToSet(this.annotations, signature);
        return signature;
    }

    @Override
    @Nonnull
    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        Set<OWLAnonymousIndividual> anons = super.getAnonymousIndividuals();
        OWLAxiomImplWithoutEntityAndAnonCaching.addAnonymousIndividualsFromAnnotationsToSet(this.annotations, anons);
        return anons;
    }
}

