/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.model;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.sparqldl.model.Filter;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryParameters;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

public class QueryImpl
implements Query {
    private static final ATermAppl DEFAULT_NAME = TermFactory.term((String)"query");
    private ATermAppl name = DEFAULT_NAME;
    private List<QueryAtom> allAtoms;
    private KnowledgeBase kb;
    private List<ATermAppl> resultVars;
    private Set<ATermAppl> allVars;
    private Set<ATermAppl> individualsAndLiterals;
    private boolean ground;
    private boolean distinct;
    private Filter filter;
    private QueryParameters parameters;
    private EnumMap<Query.VarType, Set<ATermAppl>> distVars;

    public QueryImpl(KnowledgeBase kb, boolean distinct) {
        this.kb = kb;
        this.ground = true;
        this.allAtoms = new ArrayList<QueryAtom>();
        this.resultVars = new ArrayList<ATermAppl>();
        this.allVars = new HashSet<ATermAppl>();
        this.individualsAndLiterals = new HashSet<ATermAppl>();
        this.distVars = new EnumMap(Query.VarType.class);
        for (Query.VarType type : Query.VarType.values()) {
            this.distVars.put(type, new HashSet());
        }
        this.distinct = distinct;
    }

    public QueryImpl(Query query) {
        this(query.getKB(), query.isDistinct());
        this.name = query.getName();
        this.parameters = query.getQueryParameters();
    }

    @Override
    public void add(QueryAtom atom) {
        if (this.allAtoms.contains(atom)) {
            return;
        }
        this.allAtoms.add(atom);
        for (ATermAppl a : atom.getArguments()) {
            if (ATermUtils.isVar((ATermAppl)a)) {
                if (this.allVars.contains(a)) continue;
                this.allVars.add(a);
                continue;
            }
            if (!ATermUtils.isLiteral((ATermAppl)a) && !this.kb.isIndividual((ATerm)a) || this.individualsAndLiterals.contains(a)) continue;
            this.individualsAndLiterals.add(a);
        }
        this.ground = this.ground && atom.isGround();
    }

    @Override
    public Set<ATermAppl> getDistVarsForType(Query.VarType type) {
        return this.distVars.get((Object)type);
    }

    @Override
    public void addDistVar(ATermAppl a, Query.VarType type) {
        Set<ATermAppl> set = this.distVars.get((Object)type);
        if (!set.contains(a)) {
            set.add(a);
        }
    }

    @Override
    public void addResultVar(ATermAppl a) {
        this.resultVars.add(a);
    }

    @Override
    public List<QueryAtom> getAtoms() {
        return Collections.unmodifiableList(this.allAtoms);
    }

    @Override
    public Set<ATermAppl> getConstants() {
        return Collections.unmodifiableSet(this.individualsAndLiterals);
    }

    @Override
    public Set<ATermAppl> getDistVars() {
        HashSet<ATermAppl> result = new HashSet<ATermAppl>();
        for (Query.VarType t : Query.VarType.values()) {
            result.addAll((Collection<ATermAppl>)this.distVars.get((Object)t));
        }
        return result;
    }

    @Override
    public Set<ATermAppl> getUndistVars() {
        HashSet<ATermAppl> result = new HashSet<ATermAppl>(this.allVars);
        result.removeAll(this.getDistVars());
        return result;
    }

    @Override
    public List<ATermAppl> getResultVars() {
        return Collections.unmodifiableList(this.resultVars);
    }

    @Override
    public Set<ATermAppl> getVars() {
        return Collections.unmodifiableSet(this.allVars);
    }

    @Override
    public boolean isGround() {
        return this.ground;
    }

    @Override
    public KnowledgeBase getKB() {
        return this.kb;
    }

    @Override
    public void setKB(KnowledgeBase kb) {
        this.kb = kb;
    }

    @Override
    public Query apply(ResultBinding binding) {
        ArrayList<QueryAtom> atoms = new ArrayList<QueryAtom>();
        for (QueryAtom atom : this.getAtoms()) {
            atoms.add(atom.apply(binding));
        }
        QueryImpl query = new QueryImpl(this);
        query.resultVars.addAll(this.resultVars);
        query.resultVars.removeAll(binding.getAllVariables());
        for (Query.VarType type : Query.VarType.values()) {
            for (ATermAppl atom : this.getDistVarsForType(type)) {
                if (binding.isBound(atom)) continue;
                query.addDistVar(atom, type);
            }
        }
        for (QueryAtom atom : atoms) {
            query.add(atom);
        }
        return query;
    }

    @Override
    public ATermAppl rollUpTo(ATermAppl var, Collection<ATermAppl> stopList, boolean stopOnConstants) {
        if (this.getDistVarsForType(Query.VarType.LITERAL).contains(var) && !this.getDistVarsForType(Query.VarType.INDIVIDUAL).contains(var) && !this.individualsAndLiterals.contains(var)) {
            throw new InternalReasonerException("Trying to roll up to the variable '" + var + "' which is not distinguished and individual.");
        }
        ATermList classParts = ATermUtils.EMPTY_LIST;
        HashSet<ATermAppl> visited = new HashSet<ATermAppl>();
        if (stopOnConstants) {
            visited.addAll(this.getConstants());
        }
        List<QueryAtom> inEdges = this.findAtoms(QueryPredicate.PropertyValue, null, null, var);
        for (QueryAtom a : inEdges) {
            classParts = classParts.append((ATerm)this.rollEdgeIn(QueryPredicate.PropertyValue, a, visited, stopList));
        }
        List<QueryAtom> outEdges = this.findAtoms(QueryPredicate.PropertyValue, var, null, null);
        for (QueryAtom a : outEdges) {
            classParts = classParts.append((ATerm)this.rollEdgeOut(QueryPredicate.PropertyValue, a, visited, stopList));
        }
        classParts = classParts.concat(this.getClasses(var));
        return ATermUtils.makeAnd((ATermList)classParts);
    }

    private ATermList getClasses(ATermAppl a) {
        ArrayList<ATermAppl> aterms = new ArrayList<ATermAppl>();
        for (QueryAtom atom : this.findAtoms(QueryPredicate.Type, a, null)) {
            ATermAppl arg = atom.getArguments().get(1);
            if (ATermUtils.isVar((ATermAppl)arg)) {
                throw new InternalReasonerException("Variables as predicates are not supported yet");
            }
            aterms.add(arg);
        }
        if (!ATermUtils.isVar((ATermAppl)a)) {
            aterms.add(ATermUtils.makeValue((ATerm)a));
        }
        return ATermUtils.makeList(aterms);
    }

    private ATermAppl rollEdgeOut(QueryPredicate allowed, QueryAtom atom, Set<ATermAppl> visited, Collection<ATermAppl> stopList) {
        switch (atom.getPredicate()) {
            case PropertyValue: {
                ATermList outs;
                ATermAppl subj = atom.getArguments().get(0);
                ATermAppl pred = atom.getArguments().get(1);
                ATermAppl obj = atom.getArguments().get(2);
                if (ATermUtils.isVar((ATermAppl)pred)) {
                    return ATermUtils.TOP;
                }
                visited.add(subj);
                if (visited.contains(obj)) {
                    ATermList temp = this.getClasses(obj);
                    if (temp.getLength() == 0) {
                        if (this.kb.isDatatypeProperty((ATerm)pred)) {
                            return ATermUtils.makeSomeValues((ATerm)pred, (ATerm)ATermUtils.TOP_LIT);
                        }
                        return ATermUtils.makeSomeValues((ATerm)pred, (ATerm)ATermUtils.TOP);
                    }
                    return ATermUtils.makeSomeValues((ATerm)pred, (ATerm)ATermUtils.makeAnd((ATermList)temp));
                }
                if (ATermUtils.isLiteral((ATermAppl)obj)) {
                    ATermAppl type = ATermUtils.makeValue((ATerm)obj);
                    return ATermUtils.makeSomeValues((ATerm)pred, (ATerm)type);
                }
                ATermList targetClasses = this.getClasses(obj);
                for (QueryAtom in : this._findAtoms(stopList, allowed, null, null, obj)) {
                    if (in.equals(atom)) continue;
                    targetClasses = targetClasses.append((ATerm)this.rollEdgeIn(allowed, in, visited, stopList));
                }
                List<QueryAtom> targetOuts = this._findAtoms(stopList, allowed, obj, null, null);
                if (targetClasses.isEmpty()) {
                    if (targetOuts.size() == 0) {
                        if (this.kb.isDatatypeProperty((ATerm)pred)) {
                            return ATermUtils.makeSomeValues((ATerm)pred, (ATerm)ATermUtils.TOP_LIT);
                        }
                        return ATermUtils.makeSomeValues((ATerm)pred, (ATerm)ATermUtils.TOP);
                    }
                    outs = ATermUtils.EMPTY_LIST;
                    for (QueryAtom currEdge : targetOuts) {
                        outs = outs.append((ATerm)this.rollEdgeOut(allowed, currEdge, visited, stopList));
                    }
                    return ATermUtils.makeSomeValues((ATerm)pred, (ATerm)ATermUtils.makeAnd((ATermList)outs));
                }
                if (targetOuts.size() == 0) {
                    return ATermUtils.makeSomeValues((ATerm)pred, (ATerm)ATermUtils.makeAnd((ATermList)targetClasses));
                }
                outs = ATermUtils.EMPTY_LIST;
                for (QueryAtom currEdge : targetOuts) {
                    outs = outs.append((ATerm)this.rollEdgeOut(allowed, currEdge, visited, stopList));
                }
                for (int i = 0; i < targetClasses.getLength(); ++i) {
                    outs = outs.append(targetClasses.elementAt(i));
                }
                return ATermUtils.makeSomeValues((ATerm)pred, (ATerm)ATermUtils.makeAnd((ATermList)outs));
            }
        }
        throw new RuntimeException("This atom cannot be included to rolling-up : " + atom);
    }

    /*
     * WARNING - void declaration
     */
    private ATermAppl rollEdgeIn(QueryPredicate allowed, QueryAtom atom, Set<ATermAppl> visited, Collection<ATermAppl> stopList) {
        switch (atom.getPredicate()) {
            case PropertyValue: {
                void var12_17;
                ATermList ins;
                ATermAppl subj = atom.getArguments().get(0);
                ATermAppl pred = atom.getArguments().get(1);
                ATermAppl obj = atom.getArguments().get(2);
                ATermAppl invPred = this.kb.getRBox().getRole((ATerm)pred).getInverse().getName();
                if (ATermUtils.isVar((ATermAppl)pred)) {
                    throw new InternalReasonerException("Variables as predicates are not supported yet");
                }
                visited.add(obj);
                if (visited.contains(subj)) {
                    ATermList temp = this.getClasses(subj);
                    if (temp.getLength() == 0) {
                        if (this.kb.isDatatypeProperty((ATerm)invPred)) {
                            return ATermUtils.makeSomeValues((ATerm)invPred, (ATerm)ATermUtils.TOP_LIT);
                        }
                        return ATermUtils.makeSomeValues((ATerm)invPred, (ATerm)ATermUtils.TOP);
                    }
                    return ATermUtils.makeSomeValues((ATerm)invPred, (ATerm)ATermUtils.makeAnd((ATermList)temp));
                }
                ATermList targetClasses = this.getClasses(subj);
                List<QueryAtom> targetIns = this._findAtoms(stopList, allowed, null, null, subj);
                for (QueryAtom queryAtom : this._findAtoms(stopList, allowed, subj, null, null)) {
                    if (queryAtom.equals(atom)) continue;
                    targetClasses = targetClasses.append((ATerm)this.rollEdgeOut(allowed, queryAtom, visited, stopList));
                }
                if (targetClasses.isEmpty()) {
                    if (targetIns.isEmpty()) {
                        if (this.kb.isDatatypeProperty((ATerm)pred)) {
                            return ATermUtils.makeSomeValues((ATerm)invPred, (ATerm)ATermUtils.TOP_LIT);
                        }
                        return ATermUtils.makeSomeValues((ATerm)invPred, (ATerm)ATermUtils.TOP);
                    }
                    ins = ATermUtils.EMPTY_LIST;
                    for (QueryAtom currEdge : targetIns) {
                        ins = ins.append((ATerm)this.rollEdgeIn(allowed, currEdge, visited, stopList));
                    }
                    return ATermUtils.makeSomeValues((ATerm)invPred, (ATerm)ATermUtils.makeAnd((ATermList)ins));
                }
                if (targetIns.isEmpty()) {
                    return ATermUtils.makeSomeValues((ATerm)invPred, (ATerm)ATermUtils.makeAnd((ATermList)targetClasses));
                }
                ins = ATermUtils.EMPTY_LIST;
                for (QueryAtom currEdge : targetIns) {
                    ins = ins.append((ATerm)this.rollEdgeIn(allowed, currEdge, visited, stopList));
                }
                boolean bl = false;
                while (var12_17 < targetClasses.getLength()) {
                    ins = ins.append(targetClasses.elementAt((int)var12_17));
                    ++var12_17;
                }
                return ATermUtils.makeSomeValues((ATerm)invPred, (ATerm)ATermUtils.makeAnd((ATermList)ins));
            }
        }
        throw new RuntimeException("This atom cannot be included to rolling-up : " + atom);
    }

    private List<QueryAtom> _findAtoms(Collection<ATermAppl> stopList, QueryPredicate predicate, ATermAppl ... args) {
        ArrayList<QueryAtom> list = new ArrayList<QueryAtom>();
        for (QueryAtom atom : this.allAtoms) {
            if (!predicate.equals((Object)atom.getPredicate())) continue;
            int i = 0;
            boolean add = true;
            for (ATermAppl arg : atom.getArguments()) {
                ATermAppl argValue;
                if (((argValue = args[i++]) == null || argValue == arg) && !stopList.contains(arg)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            list.add(atom);
        }
        return list;
    }

    @Override
    public List<QueryAtom> findAtoms(QueryPredicate predicate, ATermAppl ... args) {
        return this._findAtoms(Collections.emptySet(), predicate, args);
    }

    @Override
    public Query reorder(int[] ordering) {
        if (ordering.length != this.allAtoms.size()) {
            throw new InternalReasonerException("Ordering permutation must be of the same size as the query : " + ordering.length);
        }
        QueryImpl newQuery = new QueryImpl(this);
        for (int j = 0; j < ordering.length; ++j) {
            newQuery.allAtoms.add(this.allAtoms.get(ordering[j]));
        }
        newQuery.allVars = this.allVars;
        newQuery.distVars = this.distVars;
        newQuery.individualsAndLiterals = this.individualsAndLiterals;
        newQuery.resultVars = this.resultVars;
        newQuery.ground = this.ground;
        return newQuery;
    }

    @Override
    public void remove(QueryAtom atom) {
        if (!this.allAtoms.contains(atom)) {
            return;
        }
        this.allAtoms.remove(atom);
        HashSet<ATermAppl> rest = new HashSet<ATermAppl>();
        boolean ground = true;
        for (QueryAtom atom2 : this.allAtoms) {
            ground &= atom2.isGround();
            rest.addAll(atom2.getArguments());
        }
        this.ground = ground;
        HashSet<ATermAppl> toRemove = new HashSet<ATermAppl>(atom.getArguments());
        toRemove.removeAll(rest);
        for (ATermAppl a : toRemove) {
            this.allVars.remove(a);
            for (Map.Entry<Query.VarType, Set<ATermAppl>> entry : this.distVars.entrySet()) {
                entry.getValue().remove(a);
            }
            this.resultVars.remove(a);
            this.individualsAndLiterals.remove(a);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean multiLine) {
        int i;
        String indent = multiLine ? "     " : " ";
        StringBuffer sb = new StringBuffer();
        sb.append(ATermUtils.toString((ATermAppl)this.name) + "(");
        for (i = 0; i < this.resultVars.size(); ++i) {
            ATermAppl var = this.resultVars.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ATermUtils.toString((ATermAppl)var));
        }
        sb.append(")");
        if (this.allAtoms.size() > 0) {
            sb.append(" :-");
            if (multiLine) {
                sb.append("\n");
            }
            for (i = 0; i < this.allAtoms.size(); ++i) {
                QueryAtom a = this.allAtoms.get(i);
                if (i > 0) {
                    sb.append(",");
                    if (multiLine) {
                        sb.append("\n");
                    }
                }
                sb.append(indent);
                sb.append(a.toString());
            }
        }
        sb.append(".");
        if (multiLine) {
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public void setQueryParameters(QueryParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public QueryParameters getQueryParameters() {
        return this.parameters;
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public void setName(ATermAppl name) {
        this.name = name;
    }
}

