/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.formats.RDFDocumentFormat;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.rdf.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.rdf.rdfxml.parser.OWLRDFXMLParserException;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParserException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RDFXMLParser
extends AbstractOWLParser {
    private static final long serialVersionUID = 40000L;

    @Nonnull
    public String getName() {
        return "RDFXMLParser";
    }

    public OWLDocumentFormatFactory getSupportedFormat() {
        return new RDFXMLDocumentFormatFactory();
    }

    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws IOException {
        InputSource is = null;
        try {
            final RDFXMLDocumentFormat format = new RDFXMLDocumentFormat();
            RDFParser parser = new RDFParser(){

                @Override
                public void startPrefixMapping(String prefix, String uri) throws SAXException {
                    assert (prefix != null);
                    assert (uri != null);
                    super.startPrefixMapping(prefix, uri);
                    format.setPrefix(prefix, uri);
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    super.startElement(uri, localName, qName, attributes);
                }
            };
            OWLRDFConsumer consumer = new OWLRDFConsumer(ontology, configuration);
            consumer.setIRIProvider(parser);
            consumer.setOntologyFormat((RDFDocumentFormat)format);
            is = this.getInputSource(documentSource, configuration);
            parser.parse(is, consumer);
            RDFXMLDocumentFormat rDFXMLDocumentFormat = format;
            return rDFXMLDocumentFormat;
        }
        catch (RDFParserException e) {
            throw new OWLRDFXMLParserException((Throwable)((Object)e));
        }
        catch (SAXException e) {
            throw new OWLRDFXMLParserException(e);
        }
        finally {
            if (is != null && is.getByteStream() != null) {
                is.getByteStream().close();
            } else if (is != null && is.getCharacterStream() != null) {
                is.getCharacterStream().close();
            }
        }
    }
}

