/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.owlxml.parser;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormat;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserHandler;
import org.semanticweb.owlapi.util.SAXParsers;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OWLXMLParser
extends AbstractOWLParser {
    private static final long serialVersionUID = 40000L;

    @Nonnull
    public String getName() {
        return "OWLXMLParser";
    }

    public OWLDocumentFormatFactory getSupportedFormat() {
        return new OWLXMLDocumentFormatFactory();
    }

    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws IOException {
        InputSource isrc = null;
        try {
            OWLXMLDocumentFormat format = new OWLXMLDocumentFormat();
            SAXParserFactory factory = SAXParsers.initFactory();
            SAXParser parser = factory.newSAXParser();
            isrc = this.getInputSource(documentSource, configuration);
            OWLXMLParserHandler handler = new OWLXMLParserHandler(ontology, configuration);
            parser.parse(isrc, (DefaultHandler)handler);
            format.copyPrefixesFrom(handler.getPrefixName2PrefixMap());
            OWLXMLDocumentFormat oWLXMLDocumentFormat = format;
            return oWLXMLDocumentFormat;
        }
        catch (ParserConfigurationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            throw new OWLParserException((Throwable)e);
        }
        finally {
            if (isrc != null && isrc.getByteStream() != null) {
                isrc.getByteStream().close();
            } else if (isrc != null && isrc.getCharacterStream() != null) {
                isrc.getCharacterStream().close();
            }
        }
    }
}

