/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.manchestersyntax.parser;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.OWLAPIConfigProvider;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.expression.OWLExpressionParser;
import org.semanticweb.owlapi.expression.OWLOntologyChecker;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntaxParserImpl;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OntologyAxiomPair;

public class ManchesterOWLSyntaxFramesParser
implements OWLExpressionParser<Set<OntologyAxiomPair>> {
    @Nonnull
    private final OWLDataFactory dataFactory;
    @Nonnull
    private OWLEntityChecker checker;
    private OWLOntologyChecker ontologyChecker;
    private OWLOntology defaultOntology;

    public ManchesterOWLSyntaxFramesParser(@Nonnull OWLDataFactory dataFactory, @Nonnull OWLEntityChecker checker) {
        this.dataFactory = dataFactory;
        this.checker = checker;
    }

    public void setOWLEntityChecker(@Nonnull OWLEntityChecker entityChecker) {
        this.checker = entityChecker;
    }

    public void setOWLOntologyChecker(@Nonnull OWLOntologyChecker ontologyChecker) {
        this.ontologyChecker = ontologyChecker;
    }

    public void setDefaultOntology(@Nonnull OWLOntology ontology) {
        this.defaultOntology = ontology;
    }

    @Nonnull
    public Set<OntologyAxiomPair> parse(String expression) {
        ManchesterOWLSyntaxParserImpl parser = new ManchesterOWLSyntaxParserImpl(new OWLAPIConfigProvider(), this.dataFactory);
        parser.setOWLEntityChecker(this.checker);
        parser.setStringToParse(expression);
        parser.setDefaultOntology((OWLOntology)OWLAPIPreconditions.verifyNotNull((Object)this.defaultOntology));
        parser.setOWLOntologyChecker((OWLOntologyChecker)OWLAPIPreconditions.verifyNotNull((Object)this.ontologyChecker));
        return parser.parseFrames();
    }
}

