/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasPrefixedName;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.Namespaces;

public enum DublinCoreVocabulary implements HasShortForm,
HasIRI,
HasPrefixedName
{
    CONTRIBUTOR("contributor"),
    COVERAGE("coverage"),
    CREATOR("creator"),
    DATE("date"),
    DESCRIPTION("description"),
    FORMAT("format"),
    IDENTIFIER("identifier"),
    LANGUAGE("language"),
    PUBLISHER("publisher"),
    RELATION("relation"),
    RIGHTS("rights"),
    SOURCE("source"),
    SUBJECT("subject"),
    TITLE("title"),
    TYPE("type");

    @Nonnull
    private final String shortName;
    @Nonnull
    private final String qname;
    @Nonnull
    private final IRI iri;
    @Nonnull
    public static final String NAME_SPACE = "http://purl.org/dc/elements/1.1/";
    public static final Set<IRI> ALL_URIS;

    private DublinCoreVocabulary(String name) {
        this.shortName = name;
        this.qname = Namespaces.DC.getPrefixName() + ':' + name;
        this.iri = IRI.create(NAME_SPACE, name);
    }

    @Override
    public String getShortForm() {
        return this.shortName;
    }

    @Override
    public String getPrefixedName() {
        return this.qname;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    public String toString() {
        return this.iri.toString();
    }

    static {
        ALL_URIS = Sets.newHashSet((Iterable)Iterables.transform(Arrays.asList(DublinCoreVocabulary.values()), (Function)new Function<DublinCoreVocabulary, IRI>(){

            public IRI apply(DublinCoreVocabulary arg0) {
                return ((DublinCoreVocabulary)OWLAPIPreconditions.verifyNotNull((Object)arg0)).getIRI();
            }
        }));
    }
}

