/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class SpecificOntologyChangeBroadcastStrategy
implements OWLOntologyChangeBroadcastStrategy {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLOntology ontology;

    public SpecificOntologyChangeBroadcastStrategy(@Nonnull OWLOntology ontology) {
        this.ontology = (OWLOntology)OWLAPIPreconditions.checkNotNull((Object)ontology, (String)"ontology cannot be null");
    }

    @Override
    public void broadcastChanges(OWLOntologyChangeListener listener, List<? extends OWLOntologyChange> changes) throws OWLException {
        OWLAPIPreconditions.checkNotNull((Object)listener, (String)"listener cannot be null");
        OWLAPIPreconditions.checkNotNull(changes, (String)"changes cannot be null");
        ArrayList<OWLOntologyChange> broadcastChanges = new ArrayList<OWLOntologyChange>();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.getOntology().equals(this.ontology)) continue;
            broadcastChanges.add(oWLOntologyChange);
        }
        listener.ontologiesChanged(broadcastChanges);
    }
}

