/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.vocab.Namespaces;

public class OWLOntologyLoaderConfiguration
implements Serializable {
    private static final long serialVersionUID = 40000L;
    private boolean acceptHTTPCompression = true;
    private int connectionTimeout = 20000;
    private boolean followRedirects = true;
    @Nonnull
    private final Set<IRI> ignoredImports = new HashSet<IRI>();
    private boolean loadAnnotations = true;
    @Nonnull
    private MissingImportHandlingStrategy missingImportHandlingStrategy = MissingImportHandlingStrategy.THROW_EXCEPTION;
    @Nonnull
    private MissingOntologyHeaderStrategy missingOntologyHeaderStrategy = MissingOntologyHeaderStrategy.INCLUDE_GRAPH;
    private boolean reportStackTraces = false;
    private int retriesToAttempt = 5;
    private boolean strict = false;
    private boolean treatDublinCoreAsBuiltIn = true;

    public OWLOntologyLoaderConfiguration addIgnoredImport(IRI ontologyDocumentIRI) {
        OWLOntologyLoaderConfiguration configuration = this.copyConfiguration();
        configuration.ignoredImports.add(ontologyDocumentIRI);
        return configuration;
    }

    public OWLOntologyLoaderConfiguration clearIgnoredImports() {
        OWLOntologyLoaderConfiguration configuration = this.copyConfiguration();
        configuration.ignoredImports.clear();
        return configuration;
    }

    @Nonnull
    private OWLOntologyLoaderConfiguration copyConfiguration() {
        OWLOntologyLoaderConfiguration copy = new OWLOntologyLoaderConfiguration();
        copy.acceptHTTPCompression = this.acceptHTTPCompression;
        copy.connectionTimeout = this.connectionTimeout;
        copy.followRedirects = this.followRedirects;
        copy.ignoredImports.clear();
        copy.ignoredImports.addAll(this.ignoredImports);
        copy.loadAnnotations = this.loadAnnotations;
        copy.missingImportHandlingStrategy = this.missingImportHandlingStrategy;
        copy.missingOntologyHeaderStrategy = this.missingOntologyHeaderStrategy;
        copy.reportStackTraces = this.reportStackTraces;
        copy.retriesToAttempt = this.retriesToAttempt;
        copy.strict = this.strict;
        copy.treatDublinCoreAsBuiltIn = this.treatDublinCoreAsBuiltIn;
        return copy;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public MissingImportHandlingStrategy getMissingImportHandlingStrategy() {
        return this.missingImportHandlingStrategy;
    }

    public MissingOntologyHeaderStrategy getMissingOntologyHeaderStrategy() {
        return this.missingOntologyHeaderStrategy;
    }

    public int getRetriesToAttempt() {
        return this.retriesToAttempt;
    }

    public boolean isAcceptingHTTPCompression() {
        return this.acceptHTTPCompression;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public boolean isIgnoredImport(IRI iri) {
        return Namespaces.isDefaultIgnoredImport(iri) || this.ignoredImports.contains(iri);
    }

    public boolean isLoadAnnotationAxioms() {
        return this.loadAnnotations;
    }

    public boolean isReportStackTrace() {
        return this.reportStackTraces;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isTreatDublinCoreAsBuiltIn() {
        return this.treatDublinCoreAsBuiltIn;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration removeIgnoredImport(IRI ontologyDocumentIRI) {
        OWLOntologyLoaderConfiguration configuration = this.copyConfiguration();
        configuration.ignoredImports.remove(ontologyDocumentIRI);
        return configuration;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setAcceptingHTTPCompression(boolean b) {
        if (this.acceptHTTPCompression == b) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.acceptHTTPCompression = b;
        return copy;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setConnectionTimeout(int l) {
        if (l == this.connectionTimeout) {
            return this;
        }
        OWLOntologyLoaderConfiguration configuration = this.copyConfiguration();
        configuration.connectionTimeout = l;
        return configuration;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setFollowRedirects(boolean value) {
        if (value == this.followRedirects) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.followRedirects = value;
        return copy;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setLoadAnnotationAxioms(boolean b) {
        if (this.loadAnnotations == b) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.loadAnnotations = b;
        return copy;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setMissingImportHandlingStrategy(@Nonnull MissingImportHandlingStrategy missingImportHandlingStrategy) {
        if (this.missingImportHandlingStrategy == missingImportHandlingStrategy) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.missingImportHandlingStrategy = missingImportHandlingStrategy;
        return copy;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setMissingOntologyHeaderStrategy(@Nonnull MissingOntologyHeaderStrategy missingOntologyHeaderStrategy) {
        if (missingOntologyHeaderStrategy == this.missingOntologyHeaderStrategy) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.missingOntologyHeaderStrategy = missingOntologyHeaderStrategy;
        return copy;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setReportStackTraces(boolean b) {
        if (b == this.reportStackTraces) {
            return this;
        }
        OWLOntologyLoaderConfiguration configuration = this.copyConfiguration();
        configuration.reportStackTraces = b;
        return configuration;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setRetriesToAttempt(int retries) {
        if (retries == this.retriesToAttempt) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.retriesToAttempt = retries;
        return copy;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setStrict(boolean strict) {
        if (this.strict == strict) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.strict = strict;
        return copy;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration setTreatDublinCoreAsBuiltIn(boolean value) {
        if (value == this.treatDublinCoreAsBuiltIn) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.treatDublinCoreAsBuiltIn = value;
        return copy;
    }

    public static enum MissingOntologyHeaderStrategy {
        INCLUDE_GRAPH,
        IMPORT_GRAPH;

    }
}

