/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.Serializable;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.change.OWLOntologyChangeData;
import org.semanticweb.owlapi.change.OWLOntologyChangeRecord;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class OWLOntologyChange
implements HasSignature,
Serializable {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLOntology ont;

    public OWLOntologyChange(@Nonnull OWLOntology ont) {
        this.ont = (OWLOntology)OWLAPIPreconditions.checkNotNull((Object)ont, (String)"ontology must not be null");
    }

    public abstract boolean isAxiomChange();

    public abstract boolean isAddAxiom();

    public boolean isRemoveAxiom() {
        return this.isAxiomChange() && !this.isAddAxiom();
    }

    @Nonnull
    public abstract OWLAxiom getAxiom();

    public abstract boolean isImportChange();

    @Nonnull
    public OWLOntology getOntology() {
        return this.ont;
    }

    @Nonnull
    public abstract OWLOntologyChangeData getChangeData();

    @Nonnull
    public OWLOntologyChangeRecord getChangeRecord() {
        return new OWLOntologyChangeRecord(this.ont.getOntologyID(), this.getChangeData());
    }

    @Override
    @Nonnull
    public abstract Set<OWLEntity> getSignature();

    public abstract void accept(@Nonnull OWLOntologyChangeVisitor var1);

    @Nonnull
    public abstract <O> O accept(@Nonnull OWLOntologyChangeVisitorEx<O> var1);
}

