/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.io.StringDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class StringDocumentSource
extends OWLOntologyDocumentSourceBase {
    @Nonnull
    private final IRI documentIRI;
    private final String string;

    public StringDocumentSource(@Nonnull String string) {
        this(string, StringDocumentSource.getNextDocumentIRI("string:ontology"), null, null);
    }

    public StringDocumentSource(@Nonnull String string, @Nonnull IRI iri) {
        this(string, iri, null, null);
    }

    public StringDocumentSource(@Nonnull StringDocumentTarget target) {
        this(target.toString());
    }

    public StringDocumentSource(@Nonnull String string, @Nonnull IRI documentIRI, OWLDocumentFormat f, String mime) {
        super(f, mime);
        this.string = (String)OWLAPIPreconditions.checkNotNull((Object)string, (String)"string cannot be null");
        this.documentIRI = (IRI)OWLAPIPreconditions.checkNotNull((Object)documentIRI, (String)"documentIRI cannot be null");
    }

    @Override
    public boolean isReaderAvailable() {
        return true;
    }

    @Override
    public Reader getReader() {
        return new StringReader(this.string);
    }

    @Override
    public boolean isInputStreamAvailable() {
        return false;
    }

    @Override
    public InputStream getInputStream() {
        throw new OWLOntologyInputSourceException("InputStream not available.  Check with StringDocumentSource.isInputStreamAvailable() first!");
    }

    @Override
    public IRI getDocumentIRI() {
        return this.documentIRI;
    }
}

