/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class StreamDocumentSourceBase
extends OWLOntologyDocumentSourceBase {
    @Nonnull
    protected final IRI documentIRI;
    protected byte[] byteBuffer;
    private String encoding = "UTF-8";
    @Nullable
    private Boolean streamAvailable = null;

    public StreamDocumentSourceBase(@Nonnull InputStream stream, @Nonnull IRI documentIRI, OWLDocumentFormat format, String mime) {
        super(format, mime);
        this.documentIRI = (IRI)OWLAPIPreconditions.checkNotNull((Object)documentIRI, (String)"document iri cannot be null");
        this.readIntoBuffer((InputStream)OWLAPIPreconditions.checkNotNull((Object)stream, (String)"stream cannot be null"));
        this.streamAvailable = true;
    }

    public StreamDocumentSourceBase(@Nonnull Reader stream, @Nonnull IRI documentIRI, OWLDocumentFormat format, String mime) {
        super(format, mime);
        this.documentIRI = (IRI)OWLAPIPreconditions.checkNotNull((Object)documentIRI, (String)"document iri cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)stream, (String)"stream cannot be null");
        if (stream instanceof InputStreamReader) {
            this.encoding = ((InputStreamReader)stream).getEncoding();
        }
        this.readIntoBuffer(stream);
        this.streamAvailable = false;
    }

    private void readIntoBuffer(@Nonnull InputStream reader) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(bos);
            int length = 100000;
            byte[] tempBuffer = new byte[length];
            int read = 0;
            do {
                if ((read = reader.read(tempBuffer, 0, length)) <= 0) continue;
                out.write(tempBuffer, 0, read);
            } while (read > 0);
            out.finish();
            out.flush();
            this.byteBuffer = bos.toByteArray();
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void readIntoBuffer(Reader reader) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(bos);
            OutputStreamWriter writer = new OutputStreamWriter(out);
            int length = 100000;
            char[] tempBuffer = new char[length];
            int read = 0;
            do {
                if ((read = reader.read(tempBuffer, 0, length)) <= 0) continue;
                writer.write(tempBuffer, 0, read);
            } while (read > 0);
            writer.flush();
            out.finish();
            out.flush();
            this.byteBuffer = bos.toByteArray();
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    @Override
    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    @Override
    public boolean isInputStreamAvailable() {
        return Boolean.TRUE.equals(this.streamAvailable);
    }

    @Override
    public InputStream getInputStream() {
        if (!this.isInputStreamAvailable()) {
            throw new OWLOntologyInputSourceException("InputStream not available. Check with OWLOntologyDocumentSource.isInputStreamAvailable()");
        }
        try {
            return StreamDocumentSourceBase.wrap(new GZIPInputStream(new ByteArrayInputStream(this.byteBuffer)));
        }
        catch (IOException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    @Override
    public Reader getReader() {
        if (!this.isReaderAvailable()) {
            throw new OWLOntologyInputSourceException("Reader not available.  Check with OWLOntologyDocumentSource.isReaderAvailable()");
        }
        try {
            return new InputStreamReader(StreamDocumentSourceBase.wrap(new GZIPInputStream(new ByteArrayInputStream(this.byteBuffer))), this.encoding);
        }
        catch (IOException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    @Override
    public boolean isReaderAvailable() {
        return Boolean.FALSE.equals(this.streamAvailable);
    }
}

