/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class RDFTriple
implements Serializable,
Comparable<RDFTriple> {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final RDFResource subject;
    @Nonnull
    private final RDFResourceIRI predicate;
    @Nonnull
    private final RDFNode object;
    private static final List<IRI> ORDERED_URIS = Arrays.asList(OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_LABEL.getIRI(), OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI(), OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI(), OWLRDFVocabulary.OWL_DISJOINT_WITH.getIRI(), OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_DATA_RANGE.getIRI(), OWLRDFVocabulary.OWL_ON_CLASS.getIRI());

    public RDFTriple(@Nonnull RDFResource subject, @Nonnull RDFResourceIRI predicate, @Nonnull RDFNode object) {
        this.subject = (RDFResource)OWLAPIPreconditions.checkNotNull((Object)subject, (String)"subject cannot be null");
        this.predicate = (RDFResourceIRI)OWLAPIPreconditions.checkNotNull((Object)predicate, (String)"predicate cannot be null");
        this.object = (RDFNode)OWLAPIPreconditions.checkNotNull((Object)object, (String)"object cannot be null");
    }

    public RDFTriple(@Nonnull IRI subject, boolean subjectAnon, @Nonnull IRI predicate, @Nonnull IRI object, boolean objectAnon) {
        this(RDFTriple.getResource(subject, subjectAnon), new RDFResourceIRI(predicate), RDFTriple.getResource(object, objectAnon));
    }

    @Nonnull
    private static RDFResource getResource(@Nonnull IRI iri, boolean anon) {
        if (anon) {
            return new RDFResourceBlankNode(iri);
        }
        return new RDFResourceIRI(iri);
    }

    public RDFTriple(@Nonnull IRI subject, boolean subjectAnon, @Nonnull IRI predicate, @Nonnull OWLLiteral object) {
        this(RDFTriple.getResource(subject, subjectAnon), new RDFResourceIRI(predicate), new RDFLiteral(object));
    }

    @Nonnull
    public RDFResource getSubject() {
        return this.subject;
    }

    @Nonnull
    public RDFResourceIRI getPredicate() {
        return this.predicate;
    }

    @Nonnull
    public RDFNode getObject() {
        return this.object;
    }

    public int hashCode() {
        return this.subject.hashCode() * 37 + this.predicate.hashCode() * 17 + this.object.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RDFTriple)) {
            return false;
        }
        RDFTriple other = (RDFTriple)obj;
        return this.subject.equals(other.subject) && this.predicate.equals(other.predicate) && this.object.equals(other.object);
    }

    public String toString() {
        return String.format("%s %s %s.", this.subject, this.predicate, this.object);
    }

    private static int getIndex(IRI iri) {
        int index = ORDERED_URIS.indexOf(iri);
        if (index == -1) {
            index = ORDERED_URIS.size();
        }
        return index;
    }

    @Override
    public int compareTo(RDFTriple o) {
        int diff = RDFTriple.getIndex(this.predicate.getIRI()) - RDFTriple.getIndex(o.predicate.getIRI());
        if (diff == 0) {
            diff = this.subject.compareTo(o.subject);
        }
        if (diff == 0) {
            diff = this.object.compareTo(o.object);
        }
        return diff;
    }
}

