/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.Serializable;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.OWLOntologyLoaderMetaData;
import org.semanticweb.owlapi.io.RDFOntologyHeaderStatus;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RDFParserMetaData
implements OWLOntologyLoaderMetaData,
Serializable {
    private static final long serialVersionUID = 40000L;
    private final int tripleCount;
    private final RDFOntologyHeaderStatus headerStatus;
    private final Set<RDFTriple> unparsedTriples;
    private final ArrayListMultimap<IRI, Class<?>> guessedDeclarations;

    public RDFParserMetaData(@Nonnull RDFOntologyHeaderStatus headerStatus, int tripleCount, @Nonnull Set<RDFTriple> unparsedTriples, @Nonnull ArrayListMultimap<IRI, Class<?>> guessedDeclarations) {
        this.tripleCount = tripleCount;
        this.headerStatus = (RDFOntologyHeaderStatus)((Object)OWLAPIPreconditions.checkNotNull((Object)((Object)headerStatus), (String)"headerStatus cannot be null"));
        this.unparsedTriples = (Set)OWLAPIPreconditions.checkNotNull(unparsedTriples, (String)"unparsedTriples cannot be null");
        this.guessedDeclarations = (ArrayListMultimap)OWLAPIPreconditions.checkNotNull(guessedDeclarations, (String)"guessedDeclarations cannot be null");
    }

    public int getTripleCount() {
        return this.tripleCount;
    }

    public RDFOntologyHeaderStatus getHeaderState() {
        return this.headerStatus;
    }

    public Set<RDFTriple> getUnparsedTriples() {
        return CollectionFactory.getCopyOnRequestSetFromMutableCollection(this.unparsedTriples);
    }

    public Multimap<IRI, Class<?>> getGuessedDeclarations() {
        return Multimaps.unmodifiableMultimap(this.guessedDeclarations);
    }
}

