/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class RDFLiteral
extends RDFNode {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final String lexicalValue;
    @Nonnull
    private final String lang;
    @Nonnull
    private final IRI datatype;
    private int hashCode;

    public RDFLiteral(@Nonnull String literal, @Nonnull String lang, @Nullable IRI datatype) {
        this.lexicalValue = (String)OWLAPIPreconditions.checkNotNull((Object)literal, (String)"literal cannot be null");
        this.lang = lang;
        this.datatype = datatype == null ? OWL2Datatype.RDF_PLAIN_LITERAL.getIRI() : datatype;
    }

    public RDFLiteral(@Nonnull OWLLiteral literal) {
        this(literal.getLiteral(), literal.getLang(), literal.getDatatype().getIRI());
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37;
            this.hashCode = this.hashCode * 37 + this.lexicalValue.hashCode();
            this.hashCode = this.hashCode * 37 + this.lang.hashCode();
            this.hashCode = this.hashCode * 37 + this.datatype.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RDFLiteral)) {
            return false;
        }
        RDFLiteral other = (RDFLiteral)obj;
        if (!this.lexicalValue.equals(other.lexicalValue)) {
            return false;
        }
        if (!this.lang.equals(other.lang)) {
            return false;
        }
        return this.datatype.equals(other.datatype);
    }

    public String toString() {
        return this.lexicalValue;
    }

    @Override
    public IRI getIRI() {
        throw new UnsupportedOperationException("RDF Literals do not have IRIs");
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Nonnull
    public String getLexicalValue() {
        return this.lexicalValue;
    }

    @Nonnull
    public String getLang() {
        return this.lang;
    }

    @Nonnull
    public IRI getDatatype() {
        return this.datatype;
    }

    public boolean hasLang() {
        return !this.lang.isEmpty();
    }

    public boolean isPlainLiteral() {
        return OWL2Datatype.RDF_PLAIN_LITERAL.getIRI().equals(this.datatype);
    }

    @Override
    public int compareTo(RDFNode o) {
        if (!o.isLiteral()) {
            return -1;
        }
        if (this.equals(o)) {
            return 0;
        }
        int diff = 0;
        RDFLiteral lit2 = (RDFLiteral)o;
        diff = this.lexicalValue.compareTo(lit2.lexicalValue);
        if (diff == 0) {
            diff = this.getDatatype().compareTo(lit2.getDatatype());
        }
        if (diff == 0) {
            diff = this.getLang().compareTo(lit2.getLang());
        }
        return diff;
    }
}

