/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.InputStream;
import java.io.Reader;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class IRIDocumentSource
extends OWLOntologyDocumentSourceBase {
    @Nonnull
    private final IRI documentIRI;

    public IRIDocumentSource(@Nonnull IRI documentIRI) {
        this(documentIRI, null, null);
    }

    public IRIDocumentSource(@Nonnull IRI documentIRI, OWLDocumentFormat format, String mime) {
        super(format, mime);
        this.documentIRI = (IRI)OWLAPIPreconditions.checkNotNull((Object)documentIRI, (String)"document iri cannot be null");
    }

    @Override
    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    @Override
    public boolean isInputStreamAvailable() {
        return false;
    }

    @Override
    @Nonnull
    public InputStream getInputStream() {
        throw new OWLOntologyInputSourceException("InputStream not available.  Check with IRIDocumentSource.isInputStreamAvailable() first!");
    }

    @Override
    public boolean isReaderAvailable() {
        return false;
    }

    @Override
    public Reader getReader() {
        throw new OWLOntologyInputSourceException("Reader not available.  Check with IRIDocumentSource.isReaderAvailable() first!");
    }

    public String toString() {
        return this.documentIRI.toString();
    }
}

