/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class GZipStreamDocumentTarget
implements OWLOntologyDocumentTarget {
    private final OutputStream outputStream;
    private GZIPOutputStream zippedStream;

    public GZipStreamDocumentTarget(OutputStream os) {
        this.outputStream = os;
    }

    @Override
    public boolean isWriterAvailable() {
        return this.isOutputStreamAvailable();
    }

    @Override
    @Nonnull
    public Writer getWriter() {
        if (!this.isWriterAvailable()) {
            throw new UnsupportedOperationException("writer not available; check with isWriterAvailable() first.");
        }
        return new OutputStreamWriter(this.getOutputStream());
    }

    @Override
    public boolean isOutputStreamAvailable() {
        return true;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.zippedStream == null) {
            try {
                this.zippedStream = new GZIPOutputStream(this.outputStream);
            }
            catch (FileNotFoundException e) {
                throw new OWLRuntimeException(e);
            }
            catch (IOException e) {
                throw new OWLRuntimeException(e);
            }
        }
        return (OutputStream)OWLAPIPreconditions.verifyNotNull((Object)this.zippedStream);
    }

    @Override
    public boolean isDocumentIRIAvailable() {
        return false;
    }

    @Override
    public IRI getDocumentIRI() {
        throw new UnsupportedOperationException("iri not available; check with isDocumentIRIAvailable() first");
    }
}

