/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class FileDocumentTarget
implements OWLOntologyDocumentTarget {
    @Nonnull
    private final File file;

    public FileDocumentTarget(@Nonnull File file) {
        this.file = (File)OWLAPIPreconditions.checkNotNull((Object)file, (String)"file cannot be null");
    }

    @Override
    public boolean isWriterAvailable() {
        return true;
    }

    @Override
    @Nonnull
    public Writer getWriter() throws IOException {
        return new BufferedWriter(new FileWriter(this.file));
    }

    @Override
    public boolean isOutputStreamAvailable() {
        return true;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new BufferedOutputStream(new FileOutputStream(this.file));
    }

    @Override
    public boolean isDocumentIRIAvailable() {
        return true;
    }

    @Override
    public IRI getDocumentIRI() {
        return IRI.create(this.file);
    }
}

