/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class FileDocumentSource
extends OWLOntologyDocumentSourceBase {
    @Nonnull
    private final File file;

    public FileDocumentSource(@Nonnull File file) {
        this(file, null, null);
    }

    public FileDocumentSource(@Nonnull File file, OWLDocumentFormat format) {
        this(file, format, null);
    }

    public FileDocumentSource(@Nonnull File file, OWLDocumentFormat format, String mime) {
        super(format, mime);
        this.file = (File)OWLAPIPreconditions.checkNotNull((Object)file, (String)"file cannot be null");
    }

    @Override
    public IRI getDocumentIRI() {
        return IRI.create(this.file);
    }

    @Override
    public boolean isInputStreamAvailable() {
        return true;
    }

    @Override
    @Nonnull
    public InputStream getInputStream() {
        try {
            return FileDocumentSource.wrap(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    @Override
    public boolean isReaderAvailable() {
        return true;
    }

    @Override
    public Reader getReader() {
        try {
            return new BufferedReader(new InputStreamReader(this.getInputStream(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }
}

