/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public abstract class AbstractOWLParser
implements OWLParser,
Serializable {
    private static final long serialVersionUID = 40000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOWLParser.class);
    private static final String ZIP_FILE_EXTENSION = ".zip";
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private static final Pattern CONTENT_DISPOSITION_FILE_NAME_PATTERN = Pattern.compile(".*filename=\"([^\\s;]*)\".*");
    private static final int CONTENT_DISPOSITION_FILE_NAME_PATTERN_GROUP = 1;
    private static final Pattern ZIP_ENTRY_ONTOLOGY_NAME_PATTERN = Pattern.compile(".*owl|rdf|xml|mos");

    protected AbstractOWLParser() {
    }

    @Nonnull
    protected String getRequestTypes() {
        return "application/rdf+xml, application/xml; q=0.5, text/xml; q=0.3, */*; q=0.2";
    }

    @Nonnull
    protected InputStream getInputStream(@Nonnull IRI documentIRI, @Nonnull OWLOntologyLoaderConfiguration config) throws IOException {
        String requestType = this.getRequestTypes();
        URL originalURL = documentIRI.toURI().toURL();
        String originalProtocol = originalURL.getProtocol();
        URLConnection conn = originalURL.openConnection();
        conn.addRequestProperty("Accept", requestType);
        if (config.isAcceptingHTTPCompression()) {
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
        }
        int connectionTimeout = config.getConnectionTimeout();
        conn.setConnectTimeout(connectionTimeout);
        if (conn instanceof HttpURLConnection && config.isFollowRedirects()) {
            String location;
            URL newURL;
            String newProtocol;
            HttpURLConnection con = (HttpURLConnection)conn;
            con.connect();
            int responseCode = con.getResponseCode();
            if (!(responseCode != 302 && responseCode != 301 && responseCode != 303 || originalProtocol.equals(newProtocol = (newURL = new URL(location = con.getHeaderField("Location"))).getProtocol()))) {
                conn = newURL.openConnection();
                conn.addRequestProperty("Accept", requestType);
                if (config.isAcceptingHTTPCompression()) {
                    conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
                }
                conn.setConnectTimeout(connectionTimeout);
            }
        }
        String contentEncoding = conn.getContentEncoding();
        InputStream is = null;
        int count = 0;
        while (count < config.getRetriesToAttempt() && is == null) {
            try {
                is = AbstractOWLParser.getInputStreamFromContentEncoding(conn, contentEncoding);
            }
            catch (SocketTimeoutException e) {
                if (++count == 5) {
                    throw e;
                }
                conn.setConnectTimeout(connectionTimeout + connectionTimeout * count);
            }
        }
        if (is == null) {
            throw new IOException("cannot connect to " + documentIRI + "; retry limit exhausted");
        }
        if (AbstractOWLParser.isZipName(documentIRI, conn)) {
            ZipInputStream zis = new ZipInputStream(is);
            ZipEntry entry = null;
            ZipEntry nextEntry = zis.getNextEntry();
            while (entry != null && nextEntry != null) {
                if (AbstractOWLParser.couldBeOntology(nextEntry)) {
                    entry = nextEntry;
                }
                nextEntry = zis.getNextEntry();
            }
            is = OWLOntologyDocumentSourceBase.wrap(zis);
        } else {
            is = OWLOntologyDocumentSourceBase.wrap(is);
        }
        return is;
    }

    private static boolean couldBeOntology(@Nullable ZipEntry zipEntry) {
        if (zipEntry == null) {
            return false;
        }
        return ZIP_ENTRY_ONTOLOGY_NAME_PATTERN.matcher(zipEntry.getName()).matches();
    }

    @Nonnull
    private static InputStream getInputStreamFromContentEncoding(@Nonnull URLConnection conn, @Nullable String contentEncoding) throws IOException {
        InputStream is;
        if ("gzip".equals(contentEncoding)) {
            LOGGER.info("URL connection input stream is compressed using gzip");
            is = new BufferedInputStream(new GZIPInputStream(conn.getInputStream()));
        } else if ("deflate".equals(contentEncoding)) {
            LOGGER.info("URL connection input stream is compressed using deflate");
            is = OWLOntologyDocumentSourceBase.wrap(new InflaterInputStream(conn.getInputStream(), new Inflater(true)));
        } else {
            is = OWLOntologyDocumentSourceBase.wrap(conn.getInputStream());
        }
        return is;
    }

    private static boolean isZipName(@Nonnull IRI documentIRI, @Nonnull URLConnection connection) {
        if (AbstractOWLParser.isZipFileName(documentIRI.toString())) {
            return true;
        }
        String fileName = AbstractOWLParser.getFileNameFromContentDisposition(connection);
        return fileName != null && AbstractOWLParser.isZipFileName(fileName);
    }

    @Nullable
    private static String getFileNameFromContentDisposition(@Nonnull URLConnection connection) {
        Matcher matcher;
        String contentDispositionHeaderValue = connection.getHeaderField(CONTENT_DISPOSITION_HEADER);
        if (contentDispositionHeaderValue != null && (matcher = CONTENT_DISPOSITION_FILE_NAME_PATTERN.matcher(contentDispositionHeaderValue)).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private static boolean isZipFileName(@Nonnull String fileName) {
        return fileName.toLowerCase(Locale.getDefault()).endsWith(ZIP_FILE_EXTENSION);
    }

    @Nonnull
    protected InputSource getInputSource(@Nonnull OWLOntologyDocumentSource documentSource, @Nonnull OWLOntologyLoaderConfiguration config) throws IOException {
        InputSource is = documentSource.isReaderAvailable() ? new InputSource(documentSource.getReader()) : (documentSource.isInputStreamAvailable() ? new InputSource(documentSource.getInputStream()) : new InputSource(this.getInputStream(documentSource.getDocumentIRI(), config)));
        is.setSystemId(documentSource.getDocumentIRI().toString());
        return is;
    }

    @Override
    @Nonnull
    public OWLDocumentFormat parse(IRI documentIRI, OWLOntology ontology) throws IOException {
        return this.parse(new IRIDocumentSource(documentIRI, null, null), ontology, ontology.getOWLOntologyManager().getOntologyLoaderConfiguration());
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

