/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.StructureWalker;

public class OWLObjectWalker<O extends OWLObject> {
    protected OWLOntology ontology;
    private final Collection<O> objects;
    @Nullable
    protected OWLObjectVisitor visitor;
    @Nullable
    private OWLObjectVisitorEx<?> visitorEx;
    protected final boolean visitDuplicates;
    protected OWLAxiom ax;
    protected OWLAnnotation annotation;
    private final List<OWLClassExpression> classExpressionPath = new ArrayList<OWLClassExpression>();
    private final List<OWLDataRange> dataRangePath = new ArrayList<OWLDataRange>();
    @Nonnull
    private StructureWalker<O> walker = new StructureWalker(this);

    public OWLObjectWalker(@Nonnull Set<O> objects) {
        this(objects, true);
    }

    protected Object passToVisitor(OWLObject o) {
        if (this.visitor != null) {
            o.accept(this.visitor);
            return null;
        }
        assert (this.visitorEx != null);
        return o.accept(this.visitorEx);
    }

    protected void setVisitor(OWLObjectVisitorEx<?> visitor) {
        this.visitorEx = visitor;
        this.visitor = null;
    }

    protected void setVisitor(OWLObjectVisitor visitor) {
        this.visitor = visitor;
        this.visitorEx = null;
    }

    public OWLObjectWalker(@Nonnull Set<O> objects, boolean visitDuplicates) {
        this.objects = new ArrayList<O>((Collection)OWLAPIPreconditions.checkNotNull(objects, "objects cannot be null"));
        this.visitDuplicates = visitDuplicates;
    }

    public void setStructureWalker(@Nonnull StructureWalker<O> walker) {
        this.walker = walker;
    }

    public void walkStructure(@Nonnull OWLObjectVisitorEx<?> v) {
        this.setVisitor(OWLAPIPreconditions.checkNotNull(v, "v cannot be null"));
        for (OWLObject o : this.objects) {
            o.accept(this.walker);
        }
    }

    public void walkStructure(@Nonnull OWLObjectVisitor v) {
        this.setVisitor(OWLAPIPreconditions.checkNotNull(v, "v cannot be null"));
        for (OWLObject o : this.objects) {
            o.accept(this.walker);
        }
    }

    @Nullable
    public OWLOntology getOntology() {
        return this.ontology;
    }

    public OWLAxiom getAxiom() {
        return this.ax;
    }

    public OWLAnnotation getAnnotation() {
        return this.annotation;
    }

    @Nonnull
    public List<OWLClassExpression> getClassExpressionPath() {
        return new ArrayList<OWLClassExpression>(this.classExpressionPath);
    }

    public boolean isFirstClassExpressionInPath(@Nonnull OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null");
        return !this.classExpressionPath.isEmpty() && this.classExpressionPath.get(0).equals(classExpression);
    }

    protected void pushClassExpression(@Nonnull OWLClassExpression ce) {
        OWLAPIPreconditions.checkNotNull(ce, "ce cannot be null");
        this.classExpressionPath.add(ce);
    }

    protected void popClassExpression() {
        if (!this.classExpressionPath.isEmpty()) {
            this.classExpressionPath.remove(this.classExpressionPath.size() - 1);
        }
    }

    @Nonnull
    public List<OWLDataRange> getDataRangePath() {
        return new ArrayList<OWLDataRange>(this.dataRangePath);
    }

    protected void pushDataRange(@Nonnull OWLDataRange dr) {
        OWLAPIPreconditions.checkNotNull(dr, "dr cannot be null");
        this.dataRangePath.add(dr);
    }

    protected void popDataRange() {
        if (!this.dataRangePath.isEmpty()) {
            this.dataRangePath.remove(this.dataRangePath.size() - 1);
        }
    }

    public void setAxiom(OWLAxiom axiom) {
        this.ax = axiom;
    }

    public void setAnnotation(OWLAnnotation node) {
        this.annotation = node;
    }
}

