/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.search;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;

public class Filters {
    @Nonnull
    public static final OWLAxiomSearchFilter subAnnotationWithSuper = new AxiomFilter<OWLSubAnnotationPropertyOfAxiom>(AxiomType.SUB_ANNOTATION_PROPERTY_OF){
        private static final long serialVersionUID = 40000L;

        @Override
        @Nonnull
        protected Object axiomValue(@Nonnull OWLSubAnnotationPropertyOfAxiom axiom) {
            return axiom.getSuperProperty();
        }
    };
    @Nonnull
    public static final OWLAxiomSearchFilter subAnnotationWithSub = new AxiomFilter<OWLSubAnnotationPropertyOfAxiom>(AxiomType.SUB_ANNOTATION_PROPERTY_OF){
        private static final long serialVersionUID = 40000L;

        @Override
        @Nonnull
        protected Object axiomValue(@Nonnull OWLSubAnnotationPropertyOfAxiom axiom) {
            return axiom.getSubProperty();
        }
    };
    @Nonnull
    public static final OWLAxiomSearchFilter subClassWithSuper = new AxiomFilter<OWLSubClassOfAxiom>(AxiomType.SUBCLASS_OF){
        private static final long serialVersionUID = 40000L;

        @Override
        @Nonnull
        protected Object axiomValue(@Nonnull OWLSubClassOfAxiom axiom) {
            return axiom.getSuperClass();
        }
    };
    @Nonnull
    public static final OWLAxiomSearchFilter subClassWithSub = new AxiomFilter<OWLSubClassOfAxiom>(AxiomType.SUBCLASS_OF){
        private static final long serialVersionUID = 40000L;

        @Override
        @Nonnull
        protected Object axiomValue(@Nonnull OWLSubClassOfAxiom axiom) {
            return axiom.getSubClass();
        }
    };
    @Nonnull
    public static final OWLAxiomSearchFilter subObjectPropertyWithSuper = new AxiomFilter<OWLSubObjectPropertyOfAxiom>(AxiomType.SUB_OBJECT_PROPERTY){
        private static final long serialVersionUID = 40000L;

        @Override
        @Nonnull
        protected Object axiomValue(@Nonnull OWLSubObjectPropertyOfAxiom axiom) {
            return axiom.getSuperProperty();
        }
    };
    @Nonnull
    public static final OWLAxiomSearchFilter subObjectPropertyWithSub = new AxiomFilter<OWLSubObjectPropertyOfAxiom>(AxiomType.SUB_OBJECT_PROPERTY){
        private static final long serialVersionUID = 40000L;

        @Override
        @Nonnull
        protected Object axiomValue(@Nonnull OWLSubObjectPropertyOfAxiom axiom) {
            return axiom.getSubProperty();
        }
    };
    @Nonnull
    public static final OWLAxiomSearchFilter subDataPropertyWithSuper = new AxiomFilter<OWLSubDataPropertyOfAxiom>(AxiomType.SUB_DATA_PROPERTY){
        private static final long serialVersionUID = 40000L;

        @Override
        @Nonnull
        protected Object axiomValue(@Nonnull OWLSubDataPropertyOfAxiom axiom) {
            return axiom.getSuperProperty();
        }
    };
    @Nonnull
    public static final OWLAxiomSearchFilter subDataPropertyWithSub = new AxiomFilter<OWLSubDataPropertyOfAxiom>(AxiomType.SUB_DATA_PROPERTY){
        private static final long serialVersionUID = 40000L;

        @Override
        @Nonnull
        protected Object axiomValue(@Nonnull OWLSubDataPropertyOfAxiom axiom) {
            return axiom.getSubProperty();
        }
    };
    @Nonnull
    public static final OWLAxiomSearchFilter datatypeDefFilter = new AxiomFilter<OWLDatatypeDefinitionAxiom>(AxiomType.DATATYPE_DEFINITION){
        private static final long serialVersionUID = 40000L;

        @Override
        @Nonnull
        protected Object axiomValue(@Nonnull OWLDatatypeDefinitionAxiom axiom) {
            return axiom.getDatatype();
        }
    };
    @Nonnull
    public static final OWLAxiomSearchFilter apRangeFilter = new AxiomFilter<OWLAnnotationPropertyRangeAxiom>(AxiomType.ANNOTATION_PROPERTY_RANGE){
        private static final long serialVersionUID = 40000L;

        @Override
        @Nonnull
        protected Object axiomValue(@Nonnull OWLAnnotationPropertyRangeAxiom axiom) {
            return axiom.getProperty();
        }
    };
    @Nonnull
    public static final OWLAxiomSearchFilter apDomainFilter = new AxiomFilter<OWLAnnotationPropertyDomainAxiom>(AxiomType.ANNOTATION_PROPERTY_DOMAIN){
        private static final long serialVersionUID = 40000L;

        @Override
        @Nonnull
        protected Object axiomValue(@Nonnull OWLAnnotationPropertyDomainAxiom axiom) {
            return axiom.getProperty();
        }
    };
    @Nonnull
    public static final OWLAxiomSearchFilter annotations = new AxiomFilter<OWLAnnotationAssertionAxiom>(AxiomType.ANNOTATION_ASSERTION){
        private static final long serialVersionUID = 40000L;

        @Override
        @Nonnull
        protected Object axiomValue(@Nonnull OWLAnnotationAssertionAxiom axiom) {
            return axiom.getSubject();
        }
    };
    @Nonnull
    public static final OWLAxiomSearchFilter axiomsFromTBoxAndRBox = new AxiomFilter<OWLAxiom>(AxiomType.TBoxAndRBoxAxiomTypes){
        private static final long serialVersionUID = 40000L;

        @Override
        protected Object axiomValue(OWLAxiom axiom) {
            return axiom;
        }

        @Override
        public boolean pass(OWLAxiom axiom, Object key) {
            return true;
        }
    };
    @Nonnull
    public static final OWLAxiomSearchFilter axiomsNotInTBoxOrRBox = new AxiomFilter<OWLAxiom>(AxiomType.AXIOM_TYPES){
        private static final long serialVersionUID = 40000L;

        @Override
        protected Object axiomValue(OWLAxiom axiom) {
            return axiom;
        }

        @Override
        public boolean pass(@Nonnull OWLAxiom axiom, Object key) {
            return !AxiomType.TBoxAndRBoxAxiomTypes.contains(axiom.getAxiomType());
        }
    };

    private Filters() {
    }

    public static abstract class AxiomFilter<A extends OWLAxiom>
    implements OWLAxiomSearchFilter {
        private static final long serialVersionUID = 40000L;
        @Nonnull
        private final Collection<AxiomType<?>> types;

        public AxiomFilter(AxiomType<?> type) {
            this.types = CollectionFactory.list(type);
        }

        public AxiomFilter(@Nonnull Collection<AxiomType<?>> types) {
            this.types = types;
        }

        public AxiomFilter(AxiomType<?> ... types) {
            this.types = CollectionFactory.list(types);
        }

        @Override
        @Nonnull
        public Iterable<AxiomType<?>> getAxiomTypes() {
            return this.types;
        }

        @Override
        public boolean pass(@Nonnull OWLAxiom axiom, @Nonnull Object key) {
            return this.axiomValue(axiom).equals(key);
        }

        @Nonnull
        protected abstract Object axiomValue(@Nonnull A var1);
    }
}

