/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RDFResourceBlankNode
extends RDFResource {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final IRI resource;

    public RDFResourceBlankNode(@Nonnull IRI resource) {
        this.resource = OWLAPIPreconditions.checkNotNull(resource, "resource cannot be null");
    }

    public RDFResourceBlankNode(int anonId) {
        this(NodeID.nodeId(anonId));
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RDFResourceBlankNode)) {
            return false;
        }
        RDFResourceBlankNode other = (RDFResourceBlankNode)obj;
        return this.resource.equals(other.resource);
    }

    @Nonnull
    public String toString() {
        return this.resource.toString();
    }

    @Override
    public IRI getIRI() {
        return this.resource;
    }

    @Override
    public IRI getResource() {
        return this.resource;
    }
}

