/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.NodeUtils;

public class IsoMatcher {
    static boolean DEBUG = false;
    private final List<Tuple<Node>> tuples1;
    private final List<Tuple<Node>> tuples2;
    private final NodeUtils.EqualityTest nodeTest;

    public static boolean isomorphic(Graph g1, Graph g2) {
        List<Tuple<Node>> x1 = IsoMatcher.tuplesTriples((Iterator<Triple>)g1.find(null, null, null));
        List<Tuple<Node>> x2 = IsoMatcher.tuplesTriples((Iterator<Triple>)g2.find(null, null, null));
        IsoMatcher matcher = new IsoMatcher(x1, x2, NodeUtils.sameTerm);
        return matcher.match();
    }

    public static boolean isomorphic(DatasetGraph dsg1, DatasetGraph dsg2) {
        List<Tuple<Node>> x1 = IsoMatcher.tuplesQuads(dsg1.find());
        List<Tuple<Node>> x2 = IsoMatcher.tuplesQuads(dsg2.find());
        IsoMatcher matcher = new IsoMatcher(x1, x2, NodeUtils.sameTerm);
        return matcher.match();
    }

    public static boolean isomorphic(List<Tuple<Node>> x1, List<Tuple<Node>> x2) {
        x1 = new ArrayList<Tuple<Node>>(x1);
        x2 = new ArrayList<Tuple<Node>>(x2);
        IsoMatcher matcher = new IsoMatcher(x1, x2, NodeUtils.sameTerm);
        return matcher.match();
    }

    private static List<Tuple<Node>> tuplesTriples(Iterator<Triple> iter) {
        ArrayList<Tuple<Node>> tuples = new ArrayList<Tuple<Node>>();
        while (iter.hasNext()) {
            Triple t = iter.next();
            Tuple tuple = TupleFactory.tuple((Object[])new Node[]{t.getSubject(), t.getPredicate(), t.getObject()});
            tuples.add((Tuple<Node>)tuple);
        }
        return tuples;
    }

    private static List<Tuple<Node>> tuplesQuads(Iterator<Quad> iter) {
        ArrayList<Tuple<Node>> tuples = new ArrayList<Tuple<Node>>();
        while (iter.hasNext()) {
            Quad q = iter.next();
            Tuple tuple = TupleFactory.tuple((Object[])new Node[]{q.getGraph(), q.getSubject(), q.getPredicate(), q.getObject()});
            tuples.add((Tuple<Node>)tuple);
        }
        return tuples;
    }

    private IsoMatcher(List<Tuple<Node>> g1, List<Tuple<Node>> g2, NodeUtils.EqualityTest nodeTest) {
        this.tuples1 = g1;
        this.tuples2 = g2;
        this.nodeTest = nodeTest;
    }

    private boolean match() {
        return this.match(this.tuples1, this.tuples2, Mapping.rootMapping);
    }

    private boolean match(List<Tuple<Node>> tuples1, List<Tuple<Node>> tuples2, Mapping mapping) {
        if (DEBUG) {
            System.out.println("match: ");
            System.out.println("  " + tuples1);
            System.out.println("  " + tuples2);
            System.out.println("  " + mapping);
        }
        if (tuples1.size() != tuples2.size()) {
            return false;
        }
        ArrayList<Tuple<Node>> tuples = new ArrayList<Tuple<Node>>(tuples1);
        Iterator<Tuple<Node>> iterator = tuples1.iterator();
        if (iterator.hasNext()) {
            Tuple<Node> t1 = iterator.next();
            if (DEBUG) {
                System.out.println("  t1 = " + t1);
            }
            tuples.remove(t1);
            List<Cause> causes = this.match(t1, tuples2, mapping);
            for (Cause c : causes) {
                if (DEBUG) {
                    System.out.println("  Try: " + c.mapping);
                }
                Tuple<Node> t2 = c.tuple;
                tuples2.remove(t2);
                if (tuples2.isEmpty()) {
                    return true;
                }
                if (this.match(tuples, tuples2, c.mapping)) {
                    if (DEBUG) {
                        System.out.println("Yes");
                    }
                    return true;
                }
                if (DEBUG) {
                    System.out.println("No");
                }
                tuples2.add(t2);
            }
            return false;
        }
        return true;
    }

    private List<Cause> match(Tuple<Node> t1, Collection<Tuple<Node>> g2, Mapping mapping) {
        ArrayList<Cause> matches = new ArrayList<Cause>();
        for (Tuple<Node> t2 : g2) {
            Mapping step = this.gen(t1, t2, mapping);
            if (step == null) continue;
            Cause c = new Cause(t2, step);
            matches.add(c);
        }
        return matches;
    }

    private Mapping gen(Tuple<Node> t1, Tuple<Node> t2, Mapping _mapping) {
        if (t1.len() != t2.len()) {
            return null;
        }
        Mapping mapping = _mapping;
        for (int i = 0; i < t1.len(); ++i) {
            Node n2;
            Node n1 = (Node)t1.get(i);
            if (this.nodeTest.equal(n1, n2 = (Node)t2.get(i)) || (mapping = this.gen(n1, n2, mapping)) != null) continue;
            return null;
        }
        return mapping;
    }

    private Mapping gen(Node x1, Node x2, Mapping mapping) {
        if (x1.isBlank() && x2.isBlank()) {
            Node z = mapping.map(x1);
            if (z != null) {
                return this.nodeTest.equal(x2, z) ? mapping : null;
            }
            if (mapping.revmapped(x2)) {
                return null;
            }
            return new Mapping(mapping, x1, x2);
        }
        return null;
    }

    static class Cause {
        final Tuple<Node> tuple;
        final Mapping mapping;

        public Cause(Tuple<Node> tuple, Mapping mapping) {
            this.tuple = tuple;
            this.mapping = mapping;
        }
    }

    static class Mapping {
        final Node node1;
        final Node node2;
        final Mapping parent;
        static Mapping rootMapping = new Mapping(null, null, null);

        public Mapping(Mapping parent, Node node1, Node node2) {
            this.parent = parent;
            this.node1 = node1;
            this.node2 = node2;
        }

        public boolean mapped(Node node) {
            return this.map(node) != null;
        }

        public boolean revmapped(Node node) {
            return this.revmap(node) != null;
        }

        public Node map(Node node) {
            Mapping mapping = this;
            while (mapping != rootMapping) {
                if (mapping.node1.equals((Object)node)) {
                    return mapping.node2;
                }
                mapping = mapping.parent;
            }
            return null;
        }

        public Node revmap(Node node) {
            Mapping mapping = this;
            while (mapping != rootMapping) {
                if (mapping.node2.equals((Object)node)) {
                    return mapping.node1;
                }
                mapping = mapping.parent;
            }
            return null;
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            Mapping mapping = this;
            while (mapping != rootMapping) {
                sbuff.append("{" + mapping.node1 + " => " + mapping.node2 + "}");
                mapping = mapping.parent;
            }
            sbuff.append("{}");
            return sbuff.toString();
        }
    }
}

