/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import org.apache.jena.query.QueryBuildException;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;

public class eval
implements Function {
    @Override
    public void build(String uri, ExprList args) {
        if (args.size() != 1) {
            throw new QueryBuildException("'eval' takes one argument");
        }
    }

    @Override
    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        if (args == null) {
            throw new ARQInternalErrorException("function eval: Null args list");
        }
        if (args.size() != 1) {
            throw new ARQInternalErrorException("function eval: Arg list not of size 1");
        }
        Expr ex = args.get(0);
        try {
            NodeValue v = ex.eval(binding, env);
            return v;
        }
        catch (ExprEvalException evalEx) {
            return NodeValue.FALSE;
        }
    }
}

