/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.ExprVisitorFunction;
import org.apache.jena.sparql.expr.NodeValue;

public class ExprWalker {
    ExprVisitor visitor;

    public ExprWalker(ExprVisitor visitor) {
        this.visitor = visitor;
    }

    public void walk(Expr expr) {
        expr.visit(this.visitor);
    }

    public static void walk(ExprVisitor visitor, Expr expr) {
        if (expr == null) {
            return;
        }
        expr.visit(new WalkerBottomUp(visitor));
    }

    public static class WalkerBottomUp
    extends Walker {
        private WalkerBottomUp(ExprVisitor visitor) {
            super(visitor, false);
        }
    }

    public static class WalkerTopDown
    extends Walker {
        private WalkerTopDown(ExprVisitor visitor) {
            super(visitor, true);
        }
    }

    static class Walker
    extends ExprVisitorFunction {
        ExprVisitor visitor;
        boolean topDown = true;

        private Walker(ExprVisitor visitor, boolean topDown) {
            this.visitor = visitor;
            this.topDown = topDown;
        }

        @Override
        protected void visitExprFunction(ExprFunction func) {
            if (this.topDown) {
                func.visit(this.visitor);
            }
            for (int i = 1; i <= func.numArgs(); ++i) {
                Expr expr = func.getArg(i);
                if (expr == null) {
                    NodeValue.nvNothing.visit(this);
                    continue;
                }
                expr.visit(this);
            }
            if (!this.topDown) {
                func.visit(this.visitor);
            }
        }

        @Override
        public void visit(ExprFunctionOp funcOp) {
            funcOp.visit(this.visitor);
        }

        @Override
        public void visit(NodeValue nv) {
            nv.visit(this.visitor);
        }

        @Override
        public void visit(ExprVar v) {
            v.visit(this.visitor);
        }

        @Override
        public void visit(ExprAggregator eAgg) {
            eAgg.visit(this.visitor);
        }
    }
}

