/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprFunction0;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.util.Symbol;

public abstract class ExprSystem
extends ExprFunction0 {
    private final Symbol systemSymbol;

    protected ExprSystem(String fName, Symbol systemSymbol) {
        super(fName);
        this.systemSymbol = systemSymbol;
    }

    @Override
    public NodeValue eval(FunctionEnv env) {
        Object obj = env.getContext().get(this.systemSymbol);
        if (obj == null) {
            throw new ExprEvalException("null for system symbol: " + this.systemSymbol);
        }
        if (!(obj instanceof Node)) {
            throw new ExprEvalException("Not a Node: " + Lib.className((Object)obj));
        }
        Node n = (Node)obj;
        NodeValue nv = NodeValue.makeNode(n);
        return nv;
    }
}

