/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.lib.DS;
import org.apache.jena.sparql.core.Var;

public final class JoinKey
implements Iterable<Var> {
    private static final JoinKey emptyKey = new JoinKey(DS.listOfNone());
    private final List<Var> keys;

    public static JoinKey create(Collection<Var> vars1, Collection<Var> vars2) {
        List intersection = DS.list();
        for (Var v : vars1) {
            if (!vars2.contains((Object)v)) continue;
            intersection.add(v);
        }
        return new JoinKey(intersection);
    }

    public static JoinKey createVarKey(Collection<Var> vars1, Collection<Var> vars2) {
        for (Var v : vars1) {
            if (!vars2.contains((Object)v)) continue;
            return JoinKey.create(v);
        }
        return emptyKey;
    }

    public static JoinKey create(Var var) {
        return new JoinKey(var);
    }

    private JoinKey(List<Var> _keys) {
        this.keys = _keys;
    }

    private JoinKey(Var var) {
        this.keys = DS.listOfOne((Object)((Object)var));
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public int length() {
        return this.keys.size();
    }

    public Var getVarKey() {
        if (this.keys.isEmpty()) {
            return null;
        }
        return this.keys.get(0);
    }

    @Override
    public Iterator<Var> iterator() {
        return this.keys.iterator();
    }

    public String toString() {
        return this.keys.toString();
    }

    public static final class Builder {
        private List<Var> keys = DS.list();

        public boolean contains(Var var) {
            return this.keys.contains((Object)var);
        }

        public Builder add(Var var) {
            if (!this.contains(var)) {
                this.keys.add(var);
            }
            return this;
        }

        public Builder remove(Var var) {
            this.keys.remove((Object)var);
            return this;
        }

        public Builder clear() {
            this.keys.clear();
            return this;
        }

        public JoinKey build() {
            JoinKey joinKey = new JoinKey(DS.list(this.keys));
            return joinKey;
        }
    }
}

