/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.NoSuchElementException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryFatalException;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.util.PrintSerializableBase;

public abstract class QueryIteratorBase
extends PrintSerializableBase
implements QueryIterator {
    public static boolean traceIterators = false;
    private boolean finished = false;
    private volatile boolean requestingCancel = false;
    private boolean abortIterator = false;
    private Object cancelLock = new Object();
    private Throwable stackTrace = null;

    public QueryIteratorBase() {
        if (traceIterators) {
            this.stackTrace = new Throwable();
        }
    }

    protected abstract boolean hasNextBinding();

    protected abstract Binding moveToNextBinding();

    protected abstract void closeIterator();

    protected abstract void requestCancel();

    protected boolean isFinished() {
        return this.finished;
    }

    @Override
    public final boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.requestingCancel && this.abortIterator) {
            this.close();
            throw new QueryCancelledException();
        }
        boolean r = this.hasNextBinding();
        if (!r) {
            try {
                this.close();
            }
            catch (QueryFatalException ex) {
                Log.fatal((Object)this, (String)("Fatal exception: " + ex.getMessage()));
                throw ex;
            }
        }
        return r;
    }

    @Override
    public final Binding next() {
        return this.nextBinding();
    }

    @Override
    public final Binding nextBinding() {
        try {
            boolean shouldCancel = this.requestingCancel;
            if (shouldCancel && this.abortIterator) {
                this.close();
                throw new QueryCancelledException();
            }
            if (this.finished) {
                throw new NoSuchElementException(Lib.className((Object)this));
            }
            if (!this.hasNextBinding()) {
                throw new NoSuchElementException(Lib.className((Object)this));
            }
            Binding obj = this.moveToNextBinding();
            if (obj == null) {
                throw new NoSuchElementException(Lib.className((Object)this));
            }
            if (shouldCancel && !this.finished) {
                this.close();
            }
            return obj;
        }
        catch (QueryFatalException ex) {
            Log.fatal((Object)this, (String)"QueryFatalException", (Throwable)((Object)ex));
            throw ex;
        }
    }

    @Override
    public final void remove() {
        Log.warn((Object)this, (String)("Call to QueryIterator.remove() : " + Lib.className((Object)this) + ".remove"));
        throw new UnsupportedOperationException(Lib.className((Object)this) + ".remove");
    }

    public void close() {
        if (this.finished) {
            return;
        }
        try {
            this.closeIterator();
        }
        catch (QueryException ex) {
            Log.warn((Object)this, (String)"QueryException in close()", (Throwable)((Object)ex));
        }
        this.finished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancel() {
        Object object = this.cancelLock;
        synchronized (object) {
            if (!this.requestingCancel) {
                this.abortIterator = true;
                this.requestingCancel = true;
                this.requestCancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cancelAllowContinue() {
        Object object = this.cancelLock;
        synchronized (object) {
            if (!this.requestingCancel) {
                this.requestingCancel = true;
                this.requestCancel();
            }
        }
    }

    protected static void performClose(QueryIterator iter) {
        if (iter == null) {
            return;
        }
        iter.close();
    }

    protected static void performRequestCancel(QueryIterator iter) {
        if (iter == null) {
            return;
        }
        iter.cancel();
    }

    public String debug() {
        String s = "";
        if (this.stackTrace != null) {
            for (int i = 0; i < this.stackTrace.getStackTrace().length; ++i) {
                StackTraceElement e2 = this.stackTrace.getStackTrace()[i];
                if (e2.getMethodName().equals("<init>")) continue;
                s = s + e2.toString();
                break;
            }
        }
        return s;
    }
}

