/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerVocab;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class InMemDatasetAssembler
extends AssemblerBase
implements Assembler {
    public static Resource getType() {
        return DatasetAssemblerVocab.tDatasetTxnMem;
    }

    public Dataset open(Assembler assembler, Resource root2, Mode mode) {
        this.checkType(root2, DatasetAssemblerVocab.tDatasetTxnMem);
        Dataset dataset = DatasetFactory.createTxnMem();
        AssemblerUtils.setContext(root2, dataset.getContext());
        dataset.begin(ReadWrite.WRITE);
        if (root2.hasProperty(JA.data)) {
            GraphUtils.multiValueResource(root2, JA.data).forEach(defaultGraphDocument -> RDFDataMgr.read(dataset, defaultGraphDocument.getURI()));
        }
        GraphUtils.multiValueResource(root2, DatasetAssemblerVocab.pNamedGraph).forEach(namedGraphResource -> {
            String graphName = GraphUtils.getAsStringValue(namedGraphResource, DatasetAssemblerVocab.pGraphName);
            if (namedGraphResource.hasProperty(JA.data)) {
                GraphUtils.multiValueResource(namedGraphResource, JA.data).forEach(namedGraphData -> RDFDataMgr.read(dataset.getNamedModel(graphName), namedGraphData.getURI()));
            }
        });
        dataset.commit();
        dataset.end();
        return dataset;
    }
}

