/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import org.apache.jena.query.ReadWrite;
import org.apache.jena.shared.Lock;
import org.apache.jena.sparql.core.Transactional;

public class TransactionalMutex
implements Transactional {
    private final Lock lock;
    private ThreadLocal<Boolean> isInTransaction = ThreadLocal.withInitial(() -> false);

    public TransactionalMutex(Lock lock) {
        this.lock = lock;
    }

    @Override
    public void begin(ReadWrite readWrite) {
        this.lock.enterCriticalSection(false);
        this.isInTransaction.set(true);
    }

    @Override
    public void commit() {
        this.end();
    }

    @Override
    public void abort() {
        this.end();
    }

    @Override
    public boolean isInTransaction() {
        return this.isInTransaction == null ? false : this.isInTransaction.get();
    }

    @Override
    public void end() {
        if (this.isInTransaction()) {
            this.isInTransaction.set(false);
            this.lock.leaveCriticalSection();
        }
        this.isInTransaction.remove();
    }
}

