/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysRIOT {
    public static final String riotLoggerName = "org.apache.jena.riot";
    private static Logger riotLogger = LoggerFactory.getLogger((String)"org.apache.jena.riot");
    public static boolean StrictXSDLexicialForms = false;
    public static boolean strictMode = false;
    public static final boolean AbsURINoNormalization = false;
    public static final String BNodeGenIdPrefix = "genid";
    public static final Symbol rdfWriterProperties = Symbol.create("riot.rdfWriter_properties");

    public static void setStrictMode(boolean state) {
        strictMode = state;
        StrictXSDLexicialForms = state;
    }

    public static boolean isStrictMode() {
        return strictMode;
    }

    public static String fmtMessage(String message, long line, long col) {
        if (col == -1L && line == -1L) {
            return message;
        }
        if (col == -1L && line != -1L) {
            return String.format("[line: %d] %s", line, message);
        }
        if (col != -1L && line == -1L) {
            return String.format("[col: %d] %s", col, message);
        }
        return String.format("[line: %d, col: %-2d] %s", line, col, message);
    }

    public static Logger getLogger() {
        return riotLogger;
    }

    public static String chooseBaseIRI() {
        return IRIResolver.chooseBaseURI().toString();
    }

    public static String chooseBaseIRI(String baseURI) {
        String scheme = FileUtils.getScheme((String)baseURI);
        if (scheme != null && scheme.length() == 1) {
            scheme = "file";
        }
        if (scheme != null && scheme.equals("file")) {
            return IRILib.filenameToIRI((String)baseURI);
        }
        return IRIResolver.resolveString(baseURI);
    }

    public static String filename2baseIRI(String filename) {
        if (filename == null || filename.equals("-")) {
            return "http://localhost/stdin/";
        }
        String x = IRILib.filenameToIRI((String)filename);
        return x;
    }

    public static String chooseBaseIRI(String baseIRI, String fileOrIri) {
        if (baseIRI != null) {
            return baseIRI;
        }
        if (fileOrIri == null || fileOrIri.equals("-")) {
            return "http://localhost/stdin/";
        }
        return SysRIOT.chooseBaseIRI(fileOrIri);
    }
}

