/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web.auth;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.atlas.web.auth.AbstractScopedAuthenticator;

public class ScopedNTAuthenticator
extends AbstractScopedAuthenticator<Pair<Tuple<String>, char[]>> {
    private Map<URI, Pair<Tuple<String>, char[]>> credentials = new HashMap<URI, Pair<Tuple<String>, char[]>>();

    public ScopedNTAuthenticator(URI target, String username, char[] password, String workstation, String domain) {
        if (target == null) {
            throw new IllegalArgumentException("Target URI cannot be null");
        }
        this.credentials.put(target, (Pair<Tuple<String>, char[]>)Pair.create((Object)TupleFactory.tuple((Object[])new String[]{username, workstation, domain}), (Object)password));
    }

    public ScopedNTAuthenticator(Map<URI, Pair<Tuple<String>, char[]>> credentials) {
        for (Map.Entry<URI, Pair<Tuple<String>, char[]>> entry : credentials.entrySet()) {
            if (entry.getValue() == null) continue;
            if (entry.getValue().getLeft() == null) {
                throw new IllegalArgumentException("Credentials tuple should be non-null");
            }
            if (((Tuple)entry.getValue().getLeft()).len() < 3) {
                throw new IllegalArgumentException("Credentials tuple should contain at least three fields, 0 = user name, 1 = workstation, 2 = domain");
            }
            this.credentials.put(entry.getKey(), entry.getValue());
        }
    }

    public void addCredentials(URI target, String username, char[] password, String workstation, String domain) {
        if (target == null) {
            throw new IllegalArgumentException("Target URI cannot be null");
        }
        this.credentials.put(target, (Pair<Tuple<String>, char[]>)Pair.create((Object)TupleFactory.tuple((Object[])new String[]{username, workstation, domain}), (Object)password));
    }

    @Override
    protected Credentials createCredentials(URI target) {
        Pair<Tuple<String>, char[]> credentials = this.getCredentials(target);
        if (credentials == null) {
            return super.createCredentials(target);
        }
        return new NTCredentials((String)((Tuple)credentials.getLeft()).get(0), new String((char[])credentials.getRight()), (String)((Tuple)credentials.getLeft()).get(1), (String)((Tuple)credentials.getLeft()).get(2));
    }

    @Override
    protected Pair<Tuple<String>, char[]> getCredentials(URI target) {
        return this.credentials.get(target);
    }

    @Override
    protected String getUserNameFromCredentials(Pair<Tuple<String>, char[]> credentials) {
        return credentials != null ? (String)((Tuple)credentials.getLeft()).get(0) : null;
    }

    @Override
    protected char[] getPasswordFromCredentials(Pair<Tuple<String>, char[]> credentials) {
        return credentials != null ? (char[])credentials.getRight() : null;
    }
}

