/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.util.Objects;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_Blank;
import org.apache.jena.graph.Node_Literal;
import org.apache.jena.graph.Node_URI;
import org.apache.jena.graph.Node_Variable;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.graph.impl.LiteralLabelFactory;

public class NodeFactory {
    public static RDFDatatype getType(String s) {
        if (s == null) {
            return null;
        }
        return TypeMapper.getInstance().getSafeTypeByName(s);
    }

    public static Node createBlankNode() {
        return NodeFactory.createBlankNode(BlankNodeId.create());
    }

    public static Node createBlankNode(BlankNodeId id) {
        Objects.requireNonNull(id, "Argument to NodeFactory.createBlankNode is null");
        return new Node_Blank(id);
    }

    public static Node createBlankNode(String string) {
        BlankNodeId id = BlankNodeId.create(string);
        return new Node_Blank(id);
    }

    @Deprecated
    public static Node createAnon() {
        return NodeFactory.createAnon(BlankNodeId.create());
    }

    @Deprecated
    public static Node createAnon(BlankNodeId id) {
        Objects.requireNonNull(id, "Argument to NodeFactory.createAnon is null");
        return new Node_Blank(id);
    }

    @Deprecated
    public static Node createAnon(String string) {
        Objects.requireNonNull(string, "Argument to NodeFactory.createAnon is null");
        BlankNodeId id = BlankNodeId.create(string);
        return new Node_Blank(id);
    }

    public static Node createLiteral(LiteralLabel lit) {
        Objects.requireNonNull(lit, "Argument to NodeFactory.createLiteral is null");
        return new Node_Literal(lit);
    }

    public static Node createURI(String uri) {
        Objects.requireNonNull(uri, "Argument to NodeFactory.createURI is null");
        return new Node_URI(uri);
    }

    public static Node createVariable(String name) {
        Objects.requireNonNull(name, "Argument to NodeFactory.createVariable is null");
        return new Node_Variable(name);
    }

    public static Node createLiteral(String value) {
        Objects.requireNonNull(value, "Argument to NodeFactory.createLiteral is null");
        return NodeFactory.createLiteral(value, "", false);
    }

    public static Node createLiteral(String lex, String lang, boolean isXml) {
        if (lex == null) {
            throw new NullPointerException("null lexical form for literal");
        }
        return NodeFactory.createLiteral(LiteralLabelFactory.create(lex, lang, isXml));
    }

    public static Node createLiteral(String lex, String lang) {
        if (lex == null) {
            throw new NullPointerException("null lexical form for literal");
        }
        return NodeFactory.createLiteral(LiteralLabelFactory.create(lex, lang));
    }

    public static Node createLiteral(String lex, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        return NodeFactory.createLiteral(LiteralLabelFactory.createLiteralLabel(lex, lang, dtype));
    }

    public static Node createLiteral(String lex, RDFDatatype dtype) throws DatatypeFormatException {
        return NodeFactory.createLiteral(LiteralLabelFactory.create(lex, dtype));
    }

    public static Node createLiteralByValue(Object value, RDFDatatype dtype) throws DatatypeFormatException {
        Objects.requireNonNull(value, "Argument 'value' to NodeFactory.createLiteralByValue is null");
        return new Node_Literal(LiteralLabelFactory.createByValue(value, "", dtype));
    }

    public static Node createLiteralByValue(Object value, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        Objects.requireNonNull(value, "Argument 'value' to NodeFactory.createLiteralByValue is null");
        return new Node_Literal(LiteralLabelFactory.createByValue(value, lang, dtype));
    }

    @Deprecated
    public static Node createUncachedLiteral(Object value, RDFDatatype dtype) throws DatatypeFormatException {
        Objects.requireNonNull(value, "Argument 'value' to NodeFactory.createLiteralByValue is null");
        return NodeFactory.createLiteralByValue(value, dtype);
    }

    @Deprecated
    public static Node createUncachedLiteral(Object value, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        Objects.requireNonNull(value, "Argument 'value' to NodeFactory.createLiteralByValue is null");
        return NodeFactory.createLiteralByValue(value, lang, dtype);
    }
}

