/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.model;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryParameters;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryResultImpl
implements QueryResult {
    private Collection<ResultBinding> bindings;
    private List<ATermAppl> resultVars;
    private Query query;
    private QueryParameters parameters;

    public QueryResultImpl(Query query) {
        this.query = query;
        this.parameters = query.getQueryParameters();
        this.resultVars = new ArrayList<ATermAppl>(query.getResultVars());
        this.bindings = query.isDistinct() ? new HashSet<ResultBinding>() : new ArrayList<ResultBinding>();
    }

    @Override
    public void add(ResultBinding binding) {
        this.bindings.add(this.process(binding));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryResultImpl other = (QueryResultImpl)obj;
        if (this.bindings == null ? other.bindings != null : !this.bindings.equals(other.bindings)) {
            return false;
        }
        return !(this.resultVars == null ? other.resultVars != null : !this.resultVars.equals(other.resultVars));
    }

    @Override
    public List<ATermAppl> getResultVars() {
        return Collections.unmodifiableList(this.resultVars);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.bindings == null ? 0 : this.bindings.hashCode());
        result = 31 * result + (this.resultVars == null ? 0 : this.resultVars.hashCode());
        return result;
    }

    @Override
    public boolean isDistinct() {
        return this.bindings instanceof Set;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<ResultBinding> iterator() {
        return this.bindings.iterator();
    }

    @Override
    public int size() {
        return this.bindings.size();
    }

    public String toString() {
        return this.bindings.toString();
    }

    private ResultBinding process(ResultBinding binding) {
        if (this.parameters == null) {
            return binding;
        }
        int numOfVars = this.query.getResultVars().size();
        for (Map.Entry<ATermAppl, ATermAppl> entry : this.parameters.entrySet()) {
            ATermAppl var = entry.getKey();
            ATermAppl value = entry.getValue();
            if (numOfVars != 0 && !this.query.getResultVars().contains(var)) continue;
            binding.setValue(var, value);
        }
        return binding;
    }
}

