/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.ContinuousRulesStrategy;
import com.clarkparsia.pellet.rules.PartialBinding;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomObject;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.rete.BetaNode;
import com.clarkparsia.pellet.rules.rete.NodeProvider;
import com.clarkparsia.pellet.rules.rete.Token;
import com.clarkparsia.pellet.rules.rete.WME;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;

public abstract class ProductionNode
extends BetaNode {
    protected ContinuousRulesStrategy strategy;
    protected Set<ATermAppl> explain;
    protected DependencySet ds;

    public ProductionNode(ContinuousRulesStrategy strategy, Set<ATermAppl> explain) {
        this.strategy = strategy;
        this.explain = explain;
    }

    @Override
    public void activate(WME wme) {
        throw new UnsupportedOperationException();
    }

    protected void resetDependencySet(Token token) {
        boolean doExplanation = this.strategy.getABox().doExplanation();
        this.ds = token.getDepends(doExplanation);
        if (doExplanation) {
            this.ds = this.ds.union(this.explain, doExplanation);
        }
    }

    protected Node getNode(NodeProvider provider, Token token) {
        Node node = provider.getNode(null, token);
        if (node.isMerged()) {
            boolean doExplanation = this.strategy.getABox().doExplanation();
            this.ds = this.ds.union(node.getMergeDependency(true), doExplanation);
            node = node.getSame();
        }
        return node;
    }

    @Override
    public void print(String indent) {
        System.out.print(indent);
        System.out.print("  ");
        System.out.println(this);
    }

    public static class ProduceBinding
    extends ProductionNode {
        private final Rule rule;
        private final Map<AtomVariable, NodeProvider> args;

        public ProduceBinding(ContinuousRulesStrategy strategy, Set<ATermAppl> explain, Rule rule, Map<AtomVariable, NodeProvider> args) {
            super(strategy, explain);
            this.rule = rule;
            this.args = args;
        }

        @Override
        public void activate(Token token) {
            this.resetDependencySet(token);
            VariableBinding binding = new VariableBinding(this.strategy.getABox());
            for (Map.Entry<AtomVariable, NodeProvider> entry : this.args.entrySet()) {
                AtomObject arg = entry.getKey();
                Node node = this.getNode(this.args.get(arg), token);
                if (arg instanceof AtomIVariable) {
                    binding.set((AtomIObject)((AtomIVariable)arg), (Individual)node);
                    continue;
                }
                binding.set((AtomDObject)((AtomDVariable)arg), (Literal)node);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Produce binding " + this.rule + " -> " + binding);
            }
            this.strategy.addPartialBinding(new PartialBinding(this.rule, binding, this.ds));
        }

        public String toString() {
            return "Produce[Binding(" + this.args + ")]";
        }
    }

    public static class DiffFrom
    extends Binary {
        public DiffFrom(ContinuousRulesStrategy strategy, Set<ATermAppl> explain, NodeProvider subject, NodeProvider object) {
            super(strategy, explain, subject, object);
        }

        @Override
        public void activate(Token token) {
            this.resetDependencySet(token);
            Node s = this.getNode(this.subject, token);
            Node o = this.getNode(this.object, token);
            this.strategy.setDifferent(s, o, this.ds);
        }

        public String toString() {
            return "Produce[DiffFrom(" + this.subject + ", " + this.object + ")]";
        }
    }

    public static class SameAs
    extends Binary {
        public SameAs(ContinuousRulesStrategy strategy, Set<ATermAppl> explain, NodeProvider subject, NodeProvider object) {
            super(strategy, explain, subject, object);
        }

        @Override
        public void activate(Token token) {
            this.resetDependencySet(token);
            Node s = this.getNode(this.subject, token);
            Node o = this.getNode(this.object, token);
            this.strategy.mergeTo(s, o, this.ds);
        }

        public String toString() {
            return "Produce[SameAs(" + this.subject + ", " + this.object + ")]";
        }
    }

    public static class Edge
    extends Binary {
        private final Role role;

        public Edge(ContinuousRulesStrategy strategy, Set<ATermAppl> explain, NodeProvider subject, Role role, NodeProvider object) {
            super(strategy, explain, subject, object);
            this.role = role;
        }

        @Override
        public void activate(Token token) {
            this.resetDependencySet(token);
            Node s = this.getNode(this.subject, token);
            Node o = this.getNode(this.object, token);
            org.mindswap.pellet.Edge edge = this.strategy.addEdge((Individual)s, this.role, o, this.ds);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Produce edge " + token + " -> " + edge);
            }
        }

        public String toString() {
            return "Produce[" + ATermUtils.toString(this.role.getName()) + "(" + this.subject + ", " + this.object + ")]";
        }
    }

    private static abstract class Binary
    extends ProductionNode {
        protected final NodeProvider subject;
        protected final NodeProvider object;

        public Binary(ContinuousRulesStrategy strategy, Set<ATermAppl> explain, NodeProvider subject, NodeProvider object) {
            super(strategy, explain);
            this.explain = explain;
            this.subject = subject;
            this.object = object;
        }
    }

    public static class Type
    extends ProductionNode {
        private final NodeProvider subject;
        private final ATermAppl type;

        public Type(ContinuousRulesStrategy strategy, Set<ATermAppl> explain, NodeProvider subject, ATermAppl type) {
            super(strategy, explain);
            this.explain = explain;
            this.subject = subject;
            this.type = type;
        }

        @Override
        public void activate(Token token) {
            this.resetDependencySet(token);
            Node s = this.getNode(this.subject, token);
            if (!s.hasType((ATerm)this.type)) {
                this.strategy.addType(s, this.type, this.ds);
            }
        }

        public String toString() {
            return "Produce[" + ATermUtils.toString(this.type) + "(" + this.subject + ")]";
        }
    }

    public static class Inconsistency
    extends ProductionNode {
        public Inconsistency(ContinuousRulesStrategy strategy, Set<ATermAppl> explain) {
            super(strategy, explain);
        }

        @Override
        public void activate(Token token) {
            this.resetDependencySet(token);
            this.strategy.getABox().setClash(Clash.unexplained(null, this.ds));
        }

        public String toString() {
            return "Produce[clash]";
        }
    }
}

