/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.rete.AlphaNode;
import com.clarkparsia.pellet.rules.rete.WME;
import java.util.Iterator;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.iterator.IteratorUtils;
import org.mindswap.pellet.utils.iterator.NestedIterator;

public class AlphaTypeNode
extends AlphaNode {
    private final ATermAppl predicate;
    private final ATermAppl name;
    private Individual node;

    public AlphaTypeNode(ABox abox, ATermAppl predicate) {
        this(abox, predicate, null);
    }

    public AlphaTypeNode(ABox abox, ATermAppl predicate, ATermAppl name) {
        super(abox);
        this.predicate = predicate;
        this.name = name;
    }

    protected Individual initNode() {
        if (this.node == null) {
            this.node = (Individual)this.initNode(this.name);
        }
        assert (this.node != null);
        return this.node;
    }

    public boolean activate(Individual ind, ATermAppl type, DependencySet ds) {
        Individual node;
        assert (this.predicate.equals(type));
        if (this.name != null && !ind.isSame(node = this.initNode())) {
            return false;
        }
        this.activate(WME.createType(ind, type, ds));
        return true;
    }

    @Override
    public Iterator<WME> getMatches(int argIndex, Node arg) {
        if (this.name != null || argIndex != 0) {
            throw new IndexOutOfBoundsException();
        }
        if (!(arg instanceof Individual)) {
            throw new IllegalArgumentException();
        }
        DependencySet depends = arg.getDepends((ATerm)this.predicate);
        return depends == null ? IteratorUtils.emptyIterator() : IteratorUtils.singletonIterator(WME.createType((Individual)arg, this.predicate, depends));
    }

    @Override
    public Iterator<WME> getMatches() {
        Iterator<Individual> inds = this.name == null ? this.abox.getIndIterator() : IteratorUtils.singletonIterator(this.initNode());
        return new NestedIterator<Individual, WME>((Iterator)inds){

            @Override
            public Iterator<WME> getInnerIterator(Individual ind) {
                DependencySet depends = ind.getDepends((ATerm)AlphaTypeNode.this.predicate);
                return depends == null ? IteratorUtils.emptyIterator() : IteratorUtils.singletonIterator(WME.createType(ind, AlphaTypeNode.this.predicate, depends));
            }
        };
    }

    @Override
    public boolean matches(RuleAtom atom) {
        return atom instanceof ClassAtom && atom.getPredicate().equals(this.predicate) && this.argMatches((ClassAtom)atom);
    }

    private boolean argMatches(ClassAtom atom) {
        Object arg = atom.getArgument();
        return this.name == null ? arg instanceof AtomVariable : arg instanceof AtomIConstant && ((AtomIConstant)arg).getValue().equals(this.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.predicate.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AlphaTypeNode)) {
            return false;
        }
        AlphaTypeNode other = (AlphaTypeNode)obj;
        return this.predicate.equals(other.predicate) && (this.name == null ? other.name == null : this.name.equals(other.name));
    }

    public String toString() {
        return ATermUtils.toString(this.predicate) + "(" + (this.name == null ? "0" : this.name) + ")";
    }
}

