/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.model.AtomConstant;
import com.clarkparsia.pellet.rules.model.AtomObject;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BinaryAtom;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.rules.rete.AlphaDiffFromNode;
import com.clarkparsia.pellet.rules.rete.AlphaEdgeNode;
import com.clarkparsia.pellet.rules.rete.AlphaFixedObjectEdgeNode;
import com.clarkparsia.pellet.rules.rete.AlphaFixedSubjectEdgeNode;
import com.clarkparsia.pellet.rules.rete.AlphaNoVarEdgeNode;
import com.clarkparsia.pellet.rules.rete.AlphaNode;
import com.clarkparsia.pellet.rules.rete.AlphaReflexiveEdgeNode;
import com.clarkparsia.pellet.rules.rete.AlphaTypeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;

public class AlphaNetwork
implements Iterable<AlphaNode> {
    private final Map<Object, List<AlphaNode>> map = new HashMap<Object, List<AlphaNode>>();
    private final List<AlphaNode> alphaNodes = new ArrayList<AlphaNode>();
    private final AlphaNodeCreator creator = new AlphaNodeCreator();
    private final ABox abox;

    public AlphaNetwork(ABox abox) {
        this.abox = abox;
    }

    @Override
    public Iterator<AlphaNode> iterator() {
        return this.alphaNodes.iterator();
    }

    public AlphaNode addNode(RuleAtom atom) {
        Object pred = atom.getPredicate();
        List<AlphaNode> nodes = this.map.get(pred);
        if (nodes == null) {
            nodes = new ArrayList<AlphaNode>();
            this.map.put(pred, nodes);
        } else {
            for (AlphaNode node : nodes) {
                if (!node.matches(atom)) continue;
                return node;
            }
        }
        AlphaNode node = this.creator.create(atom);
        if (node != null) {
            if (node instanceof AlphaEdgeNode) {
                Role role = ((AlphaEdgeNode)node).getRole();
                this.addAlphaNodeForSubs(role, node);
                if (role.isObjectRole()) {
                    this.addAlphaNodeForSubs(role.getInverse(), node);
                }
            } else {
                nodes.add(node);
            }
        }
        this.alphaNodes.add(node);
        return node;
    }

    private void addAlphaNodeForSubs(Role r, AlphaNode node) {
        for (Role sub : r.getSubRoles()) {
            if (sub.isBottom()) continue;
            this.addAlphaNode(sub, node);
        }
    }

    private void addAlphaNode(Role r, AlphaNode node) {
        if (!r.isAnon()) {
            List<AlphaNode> subNodes = this.map.get(r.getName());
            if (subNodes == null) {
                subNodes = new ArrayList<AlphaNode>();
                this.map.put(r.getName(), subNodes);
            }
            subNodes.add(node);
        }
    }

    public void activateAll() {
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            this.activateIndividual(ind);
        }
    }

    public boolean activateIndividual(Individual ind) {
        boolean changed = false;
        if (!ind.isRootNominal() || ind.isPruned()) {
            return false;
        }
        List<ATermAppl> types = ind.getTypes(0);
        for (int i = 0; i < types.size(); ++i) {
            ATermAppl type = types.get(i);
            this.activateType(ind, type, ind.getDepends((ATerm)type));
        }
        this.activateDifferents(ind);
        for (Edge edge : ind.getOutEdges()) {
            if (!edge.getTo().isRootNominal()) continue;
            this.activateEdge(edge);
        }
        return changed;
    }

    public void activateType(Individual ind, ATermAppl type, DependencySet ds) {
        List<AlphaNode> alphas = this.map.get(type);
        if (alphas != null) {
            for (AlphaNode alpha : alphas) {
                ((AlphaTypeNode)alpha).activate(ind, type, ds);
            }
        }
    }

    public void activateEdge(Edge edge) {
        List<AlphaNode> alphas;
        Role r = edge.getRole();
        if (r.isAnon()) {
            r = r.getInverse();
        }
        if ((alphas = this.map.get(r.getName())) != null) {
            for (AlphaNode alpha : alphas) {
                ((AlphaEdgeNode)alpha).activate(edge);
            }
        }
    }

    public void activateDifferents(Individual ind) {
        List<AlphaNode> alphas = this.map.get("DIFFERENT");
        if (alphas != null) {
            for (Node n : ind.getDifferents()) {
                Individual diff = (Individual)n;
                for (AlphaNode alpha : alphas) {
                    ((AlphaDiffFromNode)alpha).activate(ind, diff, ind.getDifferenceDependency(diff));
                }
            }
        }
    }

    public void activateDifferent(Individual ind, Individual diff, DependencySet ds) {
        List<AlphaNode> alphas = this.map.get("DIFFERENT");
        if (alphas != null) {
            for (AlphaNode alpha : alphas) {
                ((AlphaDiffFromNode)alpha).activate(ind, diff, ds);
            }
        }
    }

    public void setDoExplanation(boolean doExplanation) {
        for (AlphaNode alphaNode : this.alphaNodes) {
            alphaNode.setDoExplanation(doExplanation);
        }
    }

    public void print() {
        for (AlphaNode node : this.alphaNodes) {
            node.unmark();
        }
        for (AlphaNode node : this.alphaNodes) {
            node.print("");
        }
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder();
        for (AlphaNode node : this) {
            tmp.append(node.toString()).append("\n");
        }
        return tmp.toString();
    }

    private class AlphaNodeCreator
    implements RuleAtomVisitor {
        private AlphaNode result;

        private AlphaNodeCreator() {
        }

        private AlphaNode create(RuleAtom atom) {
            this.result = null;
            atom.accept(this);
            if (this.result == null) {
                throw new UnsupportedOperationException("Not supported " + atom);
            }
            return this.result;
        }

        private void addPropertyAtom(BinaryAtom<ATermAppl, ? extends AtomObject, ? extends AtomObject> atom) {
            AtomObject s = atom.getArgument1();
            AtomObject o = atom.getArgument2();
            Role role = AlphaNetwork.this.abox.getRole((ATerm)atom.getPredicate());
            this.result = s instanceof AtomVariable && o instanceof AtomVariable ? (s.equals(o) ? new AlphaReflexiveEdgeNode(AlphaNetwork.this.abox, role) : new AlphaEdgeNode(AlphaNetwork.this.abox, role)) : (s instanceof AtomConstant ? (o instanceof AtomConstant ? new AlphaNoVarEdgeNode(AlphaNetwork.this.abox, role, ((AtomConstant)s).getValue(), ((AtomConstant)o).getValue()) : new AlphaFixedSubjectEdgeNode(AlphaNetwork.this.abox, role, ((AtomConstant)s).getValue())) : new AlphaFixedObjectEdgeNode(AlphaNetwork.this.abox, role, ((AtomConstant)o).getValue()));
        }

        @Override
        public void visit(SameIndividualAtom atom) {
        }

        @Override
        public void visit(IndividualPropertyAtom atom) {
            this.addPropertyAtom(atom);
        }

        @Override
        public void visit(DifferentIndividualsAtom atom) {
            this.result = new AlphaDiffFromNode(AlphaNetwork.this.abox);
        }

        @Override
        public void visit(DatavaluedPropertyAtom atom) {
            this.addPropertyAtom(atom);
        }

        @Override
        public void visit(DataRangeAtom atom) {
        }

        @Override
        public void visit(ClassAtom atom) {
            Object arg = atom.getArgument();
            ATermAppl name = arg instanceof AtomConstant ? ((AtomConstant)arg).getValue() : null;
            this.result = new AlphaTypeNode(AlphaNetwork.this.abox, (ATermAppl)atom.getPredicate(), name);
        }

        @Override
        public void visit(BuiltInAtom atom) {
        }
    }
}

