/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena.graph.loader;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.vocabulary.BuiltinNamespace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jena.graph.Factory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.PropertyType;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.jena.BuiltinTerm;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.graph.loader.GraphLoader;
import org.mindswap.pellet.jena.graph.loader.SimpleProperty;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.jena.vocabulary.SWRL;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.AnnotationClasses;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.mindswap.pellet.utils.progress.SilentProgressMonitor;

public class DefaultGraphLoader
implements GraphLoader {
    public static final Logger log = Logger.getLogger(DefaultGraphLoader.class.getName());
    protected static final Node[] TBOX_TYPES;
    protected static final Node[] TBOX_PREDICATES;
    private static final EnumSet<BuiltinTerm> OWL_MEMBERS_TYPES;
    private static final Graph EMPTY_GRAPH;
    public static QNameProvider qnames;
    protected KnowledgeBase kb;
    protected Graph graph;
    protected Map<Node, ATermAppl> terms;
    protected Map<Node, ATermList> lists;
    protected Set<Node> anonDatatypes;
    protected Map<Node, BuiltinTerm> naryDisjoints;
    private Map<ATermAppl, SimpleProperty> simpleProperties;
    private Set<String> unsupportedFeatures;
    private boolean loadABox = true;
    private boolean loadTBox = true;
    private boolean preprocessTypeTriples = true;
    protected ProgressMonitor monitor = new SilentProgressMonitor();

    public DefaultGraphLoader() {
        this.clear();
    }

    @Override
    public void setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor == null ? new SilentProgressMonitor() : monitor;
    }

    @Override
    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public Set<String> getUnpportedFeatures() {
        return this.unsupportedFeatures;
    }

    protected void addSimpleProperty(ATermAppl p, SimpleProperty why) {
        this.simpleProperties.put(p, why);
        Role role = this.kb.getRBox().getRole((ATerm)p);
        role.setForceSimple(true);
    }

    protected void addUnsupportedFeature(String msg) {
        if (!PelletOptions.IGNORE_UNSUPPORTED_AXIOMS) {
            throw new UnsupportedFeatureException(msg);
        }
        if (this.unsupportedFeatures.add(msg)) {
            log.warning("Unsupported axiom: " + msg);
        }
    }

    @Override
    public void clear() {
        this.terms = new HashMap<Node, ATermAppl>();
        this.terms.put(OWL.Thing.asNode(), ATermUtils.TOP);
        this.terms.put(OWL.Nothing.asNode(), ATermUtils.BOTTOM);
        this.terms.put(OWL2.topDataProperty.asNode(), ATermUtils.TOP_DATA_PROPERTY);
        this.terms.put(OWL2.bottomDataProperty.asNode(), ATermUtils.BOTTOM_DATA_PROPERTY);
        this.terms.put(OWL2.topObjectProperty.asNode(), ATermUtils.TOP_OBJECT_PROPERTY);
        this.terms.put(OWL2.bottomObjectProperty.asNode(), ATermUtils.BOTTOM_OBJECT_PROPERTY);
        this.lists = new HashMap<Node, ATermList>();
        this.lists.put(RDF.nil.asNode(), ATermUtils.EMPTY_LIST);
        this.anonDatatypes = new HashSet<Node>();
        this.simpleProperties = new HashMap<ATermAppl, SimpleProperty>();
        this.unsupportedFeatures = new HashSet<String>();
        this.naryDisjoints = new HashMap<Node, BuiltinTerm>();
    }

    private Node getObject(Node subj, Node pred) {
        ExtendedIterator i = this.graph.find(subj, pred, null);
        if (i.hasNext()) {
            Triple triple = (Triple)i.next();
            i.close();
            return triple.getObject();
        }
        return null;
    }

    private boolean hasObject(Node subj, Node pred, Node obj) {
        return this.graph.contains(subj, pred, obj);
    }

    protected Node getFirst(Node list) {
        return this.getObject(list, RDF.first.asNode());
    }

    protected Node getRest(Node list) {
        return this.getObject(list, RDF.rest.asNode());
    }

    protected ATermList createList(Node node) {
        if (this.lists.containsKey(node)) {
            return this.lists.get(node);
        }
        ATermList list = this.createList(new RDFListIterator(node));
        this.lists.put(node, list);
        return list;
    }

    protected ATermList createList(RDFListIterator i) {
        if (!i.hasNext()) {
            return ATermUtils.EMPTY_LIST;
        }
        Node node = i.next();
        if (node == null) {
            return ATermUtils.EMPTY_LIST;
        }
        ATermAppl first = this.node2term(node);
        ATermList rest = this.createList(i);
        ATermList list = ATermUtils.makeList((ATerm)first, (ATermList)rest);
        return list;
    }

    protected boolean isRestriction(Node node) {
        return this.getObject(node, OWL.onProperty.asNode()) != null;
    }

    protected ATermAppl createRestriction(Node node) throws UnsupportedFeatureException {
        Node restrictionType = null;
        Node p = null;
        Node filler = null;
        Node qualification = null;
        Bool isObjectRestriction = Bool.UNKNOWN;
        ExtendedIterator i = this.graph.find(node, null, null);
        while (i.hasNext()) {
            this.monitor.incrementProgress();
            Triple t = (Triple)i.next();
            Node pred = t.getPredicate();
            BuiltinTerm builtinTerm = BuiltinTerm.find(pred);
            if (builtinTerm == null) continue;
            switch (builtinTerm) {
                case OWL_someValuesFrom: 
                case OWL_allValuesFrom: 
                case OWL_cardinality: 
                case OWL_minCardinality: 
                case OWL_maxCardinality: 
                case OWL_hasValue: 
                case OWL2_hasSelf: 
                case OWL2_qualifiedCardinality: 
                case OWL2_minQualifiedCardinality: 
                case OWL2_maxQualifiedCardinality: {
                    restrictionType = pred;
                    filler = t.getObject();
                    break;
                }
                case OWL_onProperty: {
                    p = t.getObject();
                    break;
                }
                case RDF_type: {
                    if (!t.getObject().equals((Object)OWL2.SelfRestriction.asNode())) break;
                    restrictionType = OWL2.hasSelf.asNode();
                    filler = JenaUtils.XSD_BOOLEAN_TRUE.asNode();
                    break;
                }
                case OWL2_onClass: {
                    isObjectRestriction = Bool.TRUE;
                    qualification = t.getObject();
                    break;
                }
                case OWL2_onDataRange: {
                    isObjectRestriction = Bool.FALSE;
                    qualification = t.getObject();
                    break;
                }
            }
        }
        i.close();
        return this.createRestriction(restrictionType, p, filler, qualification, isObjectRestriction);
    }

    protected ATermAppl createRestriction(Node restrictionType, Node p, Node filler, Node qualification, Bool isObjectRestriction) throws UnsupportedFeatureException {
        ATermAppl aTerm = ATermUtils.TOP;
        if (restrictionType == null || filler == null) {
            this.addUnsupportedFeature("Skipping invalid restriction");
            return aTerm;
        }
        ATermAppl pt = this.node2term(p);
        if (restrictionType.equals((Object)OWL2.hasSelf.asNode())) {
            Object value = null;
            try {
                value = this.kb.getDatatypeReasoner().getValue(this.node2term(filler));
            }
            catch (Exception e) {
                log.log(Level.FINE, "Invalid hasSelf value: " + filler, e);
            }
            if (Boolean.TRUE.equals(value)) {
                aTerm = ATermUtils.makeSelf((ATermAppl)pt);
                this.defineObjectProperty(pt);
                this.addSimpleProperty(pt, SimpleProperty.SELF);
            } else {
                this.addUnsupportedFeature("Invalid value for " + OWL2.hasSelf.getLocalName() + " restriction. Expecting \"true\"^^xsd:boolean but found: " + filler);
            }
        } else if (restrictionType.equals((Object)OWL.hasValue.asNode())) {
            ATermAppl ot = this.node2term(filler);
            if (filler.isLiteral()) {
                this.defineDatatypeProperty(pt);
            } else {
                this.defineObjectProperty(pt);
                this.defineIndividual(ot);
            }
            aTerm = ATermUtils.makeHasValue((ATerm)pt, (ATerm)ot);
        } else if (restrictionType.equals((Object)OWL.allValuesFrom.asNode())) {
            ATermAppl ot = this.node2term(filler);
            if (this.kb.isClass((ATerm)ot)) {
                this.defineObjectProperty(pt);
            } else if (this.kb.isDatatype(ot)) {
                this.defineDatatypeProperty(pt);
            }
            aTerm = ATermUtils.makeAllValues((ATerm)pt, (ATerm)ot);
        } else if (restrictionType.equals((Object)OWL.someValuesFrom.asNode())) {
            ATermAppl ot = this.node2term(filler);
            if (this.kb.isClass((ATerm)ot)) {
                this.defineObjectProperty(pt);
            } else if (this.kb.isDatatype(ot)) {
                this.defineDatatypeProperty(pt);
            }
            aTerm = ATermUtils.makeSomeValues((ATerm)pt, (ATerm)ot);
        } else if (restrictionType.equals((Object)OWL.minCardinality.asNode()) || restrictionType.equals((Object)OWL.maxCardinality.asNode()) || restrictionType.equals((Object)OWL.cardinality.asNode()) || restrictionType.equals((Object)OWL2.minQualifiedCardinality.asNode()) || restrictionType.equals((Object)OWL2.maxQualifiedCardinality.asNode()) || restrictionType.equals((Object)OWL2.qualifiedCardinality.asNode())) {
            try {
                ATermAppl c = null;
                if (isObjectRestriction.isTrue()) {
                    c = this.node2term(qualification);
                    this.defineObjectProperty(pt);
                } else if (isObjectRestriction.isFalse()) {
                    c = this.node2term(qualification);
                    this.defineDatatypeProperty(pt);
                } else {
                    PropertyType propType = this.kb.getPropertyType((ATerm)pt);
                    if (propType == PropertyType.OBJECT) {
                        c = ATermUtils.TOP;
                    } else if (propType == PropertyType.DATATYPE) {
                        c = ATermUtils.TOP_LIT;
                    } else {
                        this.defineObjectProperty(pt);
                        c = ATermUtils.TOP;
                    }
                }
                int cardinality = Integer.parseInt(filler.getLiteral().getLexicalForm().trim());
                aTerm = restrictionType.equals((Object)OWL.minCardinality.asNode()) || restrictionType.equals((Object)OWL2.minQualifiedCardinality.asNode()) ? ATermUtils.makeMin((ATerm)pt, (int)cardinality, (ATerm)c) : (restrictionType.equals((Object)OWL.maxCardinality.asNode()) || restrictionType.equals((Object)OWL2.maxQualifiedCardinality.asNode()) ? ATermUtils.makeMax((ATerm)pt, (int)cardinality, (ATerm)c) : ATermUtils.makeCard((ATerm)pt, (int)cardinality, (ATerm)c));
                this.addSimpleProperty(pt, SimpleProperty.CARDINALITY);
            }
            catch (Exception ex) {
                this.addUnsupportedFeature("Invalid value for the owl:" + restrictionType.getLocalName() + " restriction: " + filler);
                log.log(Level.WARNING, "Invalid cardinality", ex);
            }
        } else {
            this.addUnsupportedFeature("Ignoring invalid restriction on " + p);
        }
        return aTerm;
    }

    @Override
    public ATermAppl node2term(Node node) {
        ATermAppl aTerm = this.terms.get(node);
        if (aTerm == null) {
            boolean canCache = true;
            if (this.isRestriction(node)) {
                aTerm = this.createRestriction(node);
            } else if (node.isBlank()) {
                Triple expr = this.getExpression(node);
                if (expr != null) {
                    Node exprType = expr.getPredicate();
                    Node exprValue = expr.getObject();
                    if (exprType.equals((Object)OWL.intersectionOf.asNode())) {
                        ATermList list = this.createList(exprValue);
                        aTerm = ATermUtils.makeAnd((ATermList)list);
                    } else if (exprType.equals((Object)OWL.unionOf.asNode())) {
                        ATermList list = this.createList(exprValue);
                        aTerm = ATermUtils.makeOr((ATermList)list);
                    } else if (exprType.equals((Object)OWL.complementOf.asNode()) || exprType.equals((Object)OWL2.datatypeComplementOf.asNode())) {
                        ATermAppl complement = this.node2term(exprValue);
                        aTerm = ATermUtils.makeNot((ATerm)complement);
                    } else if (exprType.equals((Object)OWL.inverseOf.asNode())) {
                        ATermAppl inverse = this.node2term(exprValue);
                        aTerm = ATermUtils.makeInv((ATermAppl)inverse);
                    } else if (exprType.equals((Object)OWL.oneOf.asNode())) {
                        ATermList list = this.createList(exprValue);
                        ATermList result = ATermUtils.EMPTY_LIST;
                        if (list.isEmpty()) {
                            aTerm = ATermUtils.BOTTOM;
                        } else {
                            ATermList l = list;
                            while (!l.isEmpty()) {
                                ATermAppl c = (ATermAppl)l.getFirst();
                                ATermAppl nominal = ATermUtils.makeValue((ATerm)c);
                                result = result.insert((ATerm)nominal);
                                l = l.getNext();
                            }
                            aTerm = ATermUtils.makeOr((ATermList)result);
                        }
                    } else if (exprType.equals((Object)OWL2.onDatatype.asNode())) {
                        aTerm = this.parseDataRange(node, exprValue);
                    } else if (exprType.equals((Object)OWL2.onDataRange.asNode())) {
                        aTerm = this.parseDataRangeLegacy(node, exprValue);
                    } else if (!exprType.equals((Object)OWL2.propertyChain.asNode())) {
                        this.addUnsupportedFeature("Unexpected bnode " + node + " " + expr);
                    }
                } else {
                    canCache = false;
                    aTerm = JenaUtils.makeATerm(node);
                }
            } else {
                aTerm = JenaUtils.makeATerm(node);
            }
            if (canCache) {
                this.terms.put(node, aTerm);
            }
        }
        return aTerm;
    }

    protected Triple getExpression(Node node) {
        for (BuiltinTerm expressionPredicate : BuiltinTerm.EXPRESSION_PREDICATES) {
            ExtendedIterator i = this.graph.find(node, expressionPredicate.getNode(), null);
            if (!i.hasNext()) continue;
            this.monitor.incrementProgress();
            Triple t = (Triple)i.next();
            i.close();
            return t;
        }
        return null;
    }

    private ATermAppl parseDataRangeLegacy(Node s, Node definition) {
        if (!definition.isURI()) {
            this.addUnsupportedFeature("Invalid datatype definition, expected URI but found " + s);
            return ATermUtils.BOTTOM_LIT;
        }
        ATermAppl baseDatatype = ATermUtils.makeTermAppl((String)definition.getURI());
        Property[] datatypeFacets = new Property[]{OWL2.minInclusive, OWL2.maxInclusive, OWL2.minExclusive, OWL2.maxExclusive, OWL2.totalDigits, OWL2.fractionDigits, OWL2.pattern};
        ArrayList<ATermAppl> restrictions = new ArrayList<ATermAppl>();
        for (Property datatypeFacet : datatypeFacets) {
            Node facetValue = this.getObject(s, datatypeFacet.asNode());
            if (facetValue == null) continue;
            ATermAppl restriction = ATermUtils.makeFacetRestriction((ATermAppl)ATermUtils.makeTermAppl((String)datatypeFacet.getURI()), (ATermAppl)JenaUtils.makeATerm(facetValue));
            restrictions.add(restriction);
        }
        if (restrictions.isEmpty()) {
            this.addUnsupportedFeature("A data range is defined without XSD facet restrictions " + s);
            return ATermUtils.BOTTOM_LIT;
        }
        return ATermUtils.makeRestrictedDatatype((ATermAppl)baseDatatype, (ATermAppl[])restrictions.toArray(new ATermAppl[restrictions.size()]));
    }

    private ATermAppl parseDataRange(Node s, Node definition) {
        if (!definition.isURI()) {
            this.addUnsupportedFeature("Invalid datatype definition, expected URI but found " + s);
            return ATermUtils.BOTTOM_LIT;
        }
        ATermAppl baseDatatype = ATermUtils.makeTermAppl((String)definition.getURI());
        Property[] datatypeFacets = new Property[]{OWL2.minInclusive, OWL2.maxInclusive, OWL2.minExclusive, OWL2.maxExclusive, OWL2.totalDigits, OWL2.fractionDigits, OWL2.pattern};
        ArrayList<ATermAppl> restrictions = new ArrayList<ATermAppl>();
        Node restrictionList = this.getObject(s, OWL2.withRestrictions.asNode());
        RDFListIterator i = new RDFListIterator(restrictionList);
        while (i.hasNext()) {
            Node restrictionNode = i.next();
            if (restrictionNode == null) continue;
            for (Property datatypeFacet : datatypeFacets) {
                Node facetValue = this.getObject(restrictionNode, datatypeFacet.asNode());
                if (facetValue == null) continue;
                ATermAppl restriction = ATermUtils.makeFacetRestriction((ATermAppl)ATermUtils.makeTermAppl((String)datatypeFacet.getURI()), (ATermAppl)JenaUtils.makeATerm(facetValue));
                restrictions.add(restriction);
            }
        }
        if (restrictions.isEmpty()) {
            this.addUnsupportedFeature("A data range is defined without XSD facet restrictions " + s);
            return ATermUtils.BOTTOM_LIT;
        }
        return ATermUtils.makeRestrictedDatatype((ATermAppl)baseDatatype, (ATermAppl[])restrictions.toArray(new ATermAppl[restrictions.size()]));
    }

    private void defineRule(Node node) {
        List<RuleAtom> head = this.parseAtomList(this.getObject(node, SWRL.head.asNode()));
        List<RuleAtom> body = this.parseAtomList(this.getObject(node, SWRL.body.asNode()));
        if (head == null || body == null) {
            String whichPart = "head and body";
            if (head != null) {
                whichPart = "body";
            } else if (body != null) {
                whichPart = "head";
            }
            this.addUnsupportedFeature("Ignoring SWRL rule (unsupported " + whichPart + "): " + node);
            return;
        }
        ATermAppl name = JenaUtils.makeATerm(node);
        Rule rule = new Rule(name, head, body);
        this.kb.addRule(rule);
    }

    private AtomDObject createRuleDObject(Node node) {
        if (!node.isLiteral()) {
            ATermAppl name = this.node2term(node);
            if (!ATermUtils.isPrimitive((ATermAppl)name)) {
                this.addUnsupportedFeature("Cannot create rule data variable out of " + node);
                return null;
            }
            return new AtomDVariable(name.toString());
        }
        return new AtomDConstant(this.node2term(node));
    }

    private AtomIObject createRuleIObject(Node node) {
        if (this.hasObject(node, RDF.type.asNode(), SWRL.Variable.asNode())) {
            return new AtomIVariable(node.getURI());
        }
        ATermAppl term = this.node2term(node);
        if (this.defineIndividual(term)) {
            return new AtomIConstant(this.node2term(node));
        }
        this.addUnsupportedFeature("Cannot create rule individual object for node " + node);
        return null;
    }

    private List<RuleAtom> parseAtomList(Node atomList) {
        Node obj = null;
        ArrayList<RuleAtom> atoms = new ArrayList<RuleAtom>();
        while (atomList != null && !atomList.equals((Object)RDF.nil.asNode())) {
            AtomIObject argument2;
            AtomIObject argument1;
            AtomIObject argument22;
            AtomIObject argument12;
            ATermAppl pred;
            AtomIObject argument;
            String atomType = "unsupported atom";
            Node atomNode = this.getObject(atomList, RDF.first.asNode());
            ClassAtom atom = null;
            if (this.hasObject(atomNode, RDF.type.asNode(), SWRL.ClassAtom.asNode())) {
                ATermAppl description = null;
                argument = null;
                atomType = "ClassAtom";
                obj = this.getObject(atomNode, SWRL.classPredicate.asNode());
                if (obj != null) {
                    description = this.node2term(obj);
                }
                if ((obj = this.getObject(atomNode, SWRL.argument1.asNode())) != null) {
                    argument = this.createRuleIObject(obj);
                }
                if (description == null) {
                    this.addUnsupportedFeature("Error on " + SWRL.classPredicate);
                } else if (argument == null) {
                    this.addUnsupportedFeature("Error on" + SWRL.argument1);
                } else {
                    atom = new ClassAtom(description, argument);
                }
            } else if (this.hasObject(atomNode, RDF.type.asNode(), SWRL.IndividualPropertyAtom.asNode())) {
                pred = null;
                argument12 = null;
                argument22 = null;
                atomType = "IndividualPropertyAtom";
                obj = this.getObject(atomNode, SWRL.propertyPredicate.asNode());
                if (obj != null) {
                    pred = this.node2term(obj);
                }
                if ((obj = this.getObject(atomNode, SWRL.argument1.asNode())) != null) {
                    argument12 = this.createRuleIObject(obj);
                }
                if ((obj = this.getObject(atomNode, SWRL.argument2.asNode())) != null) {
                    argument22 = this.createRuleIObject(obj);
                }
                if (pred == null || !this.defineObjectProperty(pred)) {
                    this.addUnsupportedFeature("Cannot define datatype property " + pred);
                } else if (argument12 == null) {
                    this.addUnsupportedFeature("Term not found: " + SWRL.argument1);
                } else if (argument22 == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.argument2);
                } else {
                    atom = new IndividualPropertyAtom(pred, argument12, argument22);
                }
            } else if (this.hasObject(atomNode, RDF.type.asNode(), SWRL.DifferentIndividualsAtom.asNode())) {
                argument1 = null;
                argument2 = null;
                atomType = "DifferentIndividualsAtom";
                obj = this.getObject(atomNode, SWRL.argument1.asNode());
                if (obj != null) {
                    argument1 = this.createRuleIObject(obj);
                }
                if ((obj = this.getObject(atomNode, SWRL.argument2.asNode())) != null) {
                    argument2 = this.createRuleIObject(obj);
                }
                if (argument1 == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.argument1);
                } else if (argument2 == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.argument2);
                } else {
                    atom = new DifferentIndividualsAtom(argument1, argument2);
                }
            } else if (this.hasObject(atomNode, RDF.type.asNode(), SWRL.SameIndividualAtom.asNode())) {
                argument1 = null;
                argument2 = null;
                atomType = "SameIndividualAtom";
                obj = this.getObject(atomNode, SWRL.argument1.asNode());
                if (obj != null) {
                    argument1 = this.createRuleIObject(obj);
                }
                if ((obj = this.getObject(atomNode, SWRL.argument2.asNode())) != null) {
                    argument2 = this.createRuleIObject(obj);
                }
                if (argument1 == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.argument1);
                } else if (argument2 == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.argument2);
                } else {
                    atom = new SameIndividualAtom(argument1, argument2);
                }
            } else if (this.hasObject(atomNode, RDF.type.asNode(), SWRL.DatavaluedPropertyAtom.asNode())) {
                pred = null;
                argument12 = null;
                argument22 = null;
                atomType = "DatavaluedPropertyAtom";
                obj = this.getObject(atomNode, SWRL.propertyPredicate.asNode());
                if (obj != null) {
                    pred = this.node2term(obj);
                }
                if ((obj = this.getObject(atomNode, SWRL.argument1.asNode())) != null) {
                    argument12 = this.createRuleIObject(obj);
                }
                if ((obj = this.getObject(atomNode, SWRL.argument2.asNode())) != null) {
                    argument22 = this.createRuleDObject(obj);
                }
                if (pred == null || !this.defineDatatypeProperty(pred)) {
                    this.addUnsupportedFeature("Cannot define datatype property " + pred);
                } else if (argument12 == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.argument1);
                } else if (argument22 == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.argument2);
                } else {
                    atom = new DatavaluedPropertyAtom(pred, argument12, (AtomDObject)argument22);
                }
            } else if (this.hasObject(atomNode, RDF.type.asNode(), SWRL.BuiltinAtom.asNode())) {
                atomType = "BuiltinAtom";
                Node builtInNode = null;
                List<AtomDObject> arguments = null;
                obj = this.getObject(atomNode, SWRL.arguments.asNode());
                if (obj != null) {
                    arguments = this.parseArgumentList(obj);
                }
                builtInNode = this.getObject(atomNode, SWRL.builtin.asNode());
                if (arguments == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.arguments);
                } else if (builtInNode != null && builtInNode.isURI()) {
                    atom = new BuiltInAtom(builtInNode.getURI(), arguments);
                }
            } else if (this.hasObject(atomNode, RDF.type.asNode(), SWRL.DataRangeAtom.asNode())) {
                atomType = "DataRangeAtom";
                ATermAppl datatype = null;
                argument = null;
                obj = this.getObject(atomNode, SWRL.dataRange.asNode());
                if (obj != null) {
                    datatype = this.node2term(obj);
                }
                if ((obj = this.getObject(atomNode, SWRL.argument1.asNode())) != null) {
                    argument = this.createRuleDObject(obj);
                }
                if (datatype == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.dataRange);
                } else if (argument == null) {
                    this.addUnsupportedFeature("Term not found " + SWRL.argument1);
                } else {
                    atom = new DataRangeAtom(datatype, (AtomDObject)argument);
                }
            }
            if (atom == null) {
                this.addUnsupportedFeature("Ignoring SWRL " + atomType + ": " + atomNode);
                return null;
            }
            atoms.add((RuleAtom)atom);
            atomList = this.getObject(atomList, RDF.rest.asNode());
        }
        if (atomList == null) {
            this.addUnsupportedFeature("Not nil-terminated list in atom list! (Seen " + atoms + " )");
            return null;
        }
        return atoms;
    }

    private List<AtomDObject> parseArgumentList(Node argumentList) {
        ArrayList<AtomDObject> arguments = new ArrayList<AtomDObject>();
        while (argumentList != null && !argumentList.equals((Object)RDF.nil.asNode())) {
            Node argumentNode = this.getObject(argumentList, RDF.first.asNode());
            if (argumentNode == null) {
                this.addUnsupportedFeature("Term in list not found " + RDF.first);
                continue;
            }
            arguments.add(this.createRuleDObject(argumentNode));
            argumentList = this.getObject(argumentList, RDF.rest.asNode());
        }
        return arguments;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean addNegatedAssertion(Node stmt) {
        ATermAppl ot;
        Node s = this.getObject(stmt, OWL2.sourceIndividual.asNode());
        if (s == null) {
            this.addUnsupportedFeature("Negated property value is missing owl:sourceIndividual value");
            return false;
        }
        Node p = this.getObject(stmt, OWL2.assertionProperty.asNode());
        if (p == null) {
            this.addUnsupportedFeature("Negated property value is missing owl:assertionProperty value");
            return false;
        }
        Node oi = this.getObject(stmt, OWL2.targetIndividual.asNode());
        Node ov = this.getObject(stmt, OWL2.targetValue.asNode());
        if (oi == null && ov == null) {
            this.addUnsupportedFeature("Negated property value is missing owl:targetIndividual or owl:targetValue value");
            return false;
        }
        if (oi != null && ov != null) {
            this.addUnsupportedFeature("Negated property value must not have owl:targetIndividual and owl:targetValue value");
            return false;
        }
        ATermAppl st = this.node2term(s);
        ATermAppl pt = this.node2term(p);
        this.defineIndividual(st);
        if (oi != null) {
            ot = this.node2term(oi);
            if (!oi.isURI() && !oi.isBlank()) {
                this.addUnsupportedFeature("Invalid negated property target individual " + stmt);
                return false;
            }
            this.defineObjectProperty(pt);
            this.defineIndividual(ot);
        } else {
            ot = this.node2term(ov);
            if (!ov.isLiteral()) {
                this.addUnsupportedFeature("Invalid negated property target value " + stmt);
                return false;
            }
            this.defineDatatypeProperty(pt);
        }
        if (!this.kb.addNegatedPropertyValue(pt, st, ot)) {
            this.addUnsupportedFeature("Skipping invalid negated property value " + stmt);
            return false;
        }
        return true;
    }

    protected boolean defineClass(ATermAppl c) {
        if (ATermUtils.isPrimitive((ATermAppl)c)) {
            this.kb.addClass(c);
            return true;
        }
        return ATermUtils.isComplexClass((ATerm)c);
    }

    protected boolean defineDatatype(ATermAppl dt) {
        if (ATermUtils.isPrimitive((ATermAppl)dt)) {
            this.kb.addDatatype(dt);
            return true;
        }
        return this.kb.isDatatype(dt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean defineProperties(ATermAppl p1, ATermAppl p2) {
        PropertyType type2;
        PropertyType type1 = this.kb.getPropertyType((ATerm)p1);
        if (type1 != (type2 = this.kb.getPropertyType((ATerm)p2))) {
            if (type1 == PropertyType.UNTYPED) {
                if (type2 == PropertyType.OBJECT) {
                    this.defineObjectProperty(p1);
                    return true;
                } else {
                    if (type2 != PropertyType.DATATYPE) return true;
                    this.defineDatatypeProperty(p1);
                }
                return true;
            } else {
                if (type2 != PropertyType.UNTYPED) return false;
                if (type1 == PropertyType.OBJECT) {
                    this.defineObjectProperty(p2);
                    return true;
                } else {
                    if (type1 != PropertyType.DATATYPE) return true;
                    this.defineDatatypeProperty(p2);
                }
            }
            return true;
        } else {
            if (type1 != PropertyType.UNTYPED) return true;
            this.defineProperty(p1);
            this.defineProperty(p2);
        }
        return true;
    }

    protected boolean defineObjectProperty(ATermAppl c) {
        if (!ATermUtils.isPrimitive((ATermAppl)c) && !ATermUtils.isInv((ATermAppl)c)) {
            return false;
        }
        return this.kb.addObjectProperty((ATerm)c);
    }

    protected boolean defineDatatypeProperty(ATermAppl c) {
        if (!ATermUtils.isPrimitive((ATermAppl)c)) {
            return false;
        }
        return this.kb.addDatatypeProperty((ATerm)c);
    }

    private boolean defineAnnotationProperty(ATermAppl c) {
        if (!ATermUtils.isPrimitive((ATermAppl)c)) {
            return false;
        }
        return this.kb.addAnnotationProperty((ATerm)c);
    }

    protected boolean defineProperty(ATermAppl c) {
        if (ATermUtils.isInv((ATermAppl)c)) {
            this.kb.addObjectProperty(c.getArgument(0));
            return true;
        }
        if (!ATermUtils.isPrimitive((ATermAppl)c)) {
            return false;
        }
        this.kb.addProperty(c);
        return true;
    }

    protected boolean defineIndividual(ATermAppl c) {
        this.kb.addIndividual(c);
        return true;
    }

    private PropertyType guessPropertyType(ATermAppl p, Node prop) {
        PropertyType roleType = this.kb.getPropertyType((ATerm)p);
        if (roleType != PropertyType.UNTYPED) {
            return roleType;
        }
        this.defineProperty(p);
        ExtendedIterator i = this.graph.find(prop, RDF.type.asNode(), null);
        while (i.hasNext()) {
            Triple stmt = (Triple)i.next();
            Node o = stmt.getObject();
            if (o.equals((Object)OWL.ObjectProperty.asNode())) {
                return PropertyType.OBJECT;
            }
            if (o.equals((Object)OWL.DatatypeProperty.asNode())) {
                return PropertyType.DATATYPE;
            }
            if (o.equals((Object)OWL.AnnotationProperty.asNode())) {
                return PropertyType.ANNOTATION;
            }
            if (!o.equals((Object)OWL.OntologyProperty.asNode())) continue;
            return PropertyType.ANNOTATION;
        }
        return PropertyType.UNTYPED;
    }

    protected void processTypes() {
        if (this.preprocessTypeTriples) {
            log.fine("processTypes");
            if (this.isLoadABox()) {
                this.processTypes(Node.ANY);
            } else {
                for (Node type : TBOX_TYPES) {
                    this.processTypes(type);
                }
            }
        }
    }

    protected void processTypes(Node type) {
        ExtendedIterator i = this.graph.find(null, RDF.type.asNode(), type);
        while (i.hasNext()) {
            Triple stmt = (Triple)i.next();
            this.processType(stmt);
        }
        i.close();
    }

    protected void processType(Triple triple) {
        Node s = triple.getSubject();
        Node o = triple.getObject();
        BuiltinTerm builtinTerm = BuiltinTerm.find(o);
        if (builtinTerm != null) {
            if (builtinTerm.isSyntax()) {
                return;
            }
            if (s.isBlank() && builtinTerm.equals((Object)BuiltinTerm.OWL_Class)) {
                return;
            }
        }
        this.monitor.incrementProgress();
        ATermAppl st = this.node2term(s);
        if (builtinTerm == null) {
            BuiltinNamespace builtin;
            String nameSpace;
            if (PelletOptions.FREEZE_BUILTIN_NAMESPACES && o.isURI() && (nameSpace = o.getNameSpace()) != null && (builtin = BuiltinNamespace.find((String)nameSpace)) != null) {
                this.addUnsupportedFeature("Ignoring triple with unknown term from " + builtin + " namespace: " + triple);
                return;
            }
            return;
        }
        switch (builtinTerm) {
            case RDF_Property: {
                this.defineProperty(st);
                break;
            }
            case RDFS_Class: {
                this.defineClass(st);
                break;
            }
            case RDFS_Datatype: 
            case OWL_DataRange: {
                if (s.isURI()) {
                    this.defineDatatype(st);
                    break;
                }
                this.anonDatatypes.add(s);
                break;
            }
            case OWL_Class: {
                this.defineClass(st);
                break;
            }
            case OWL_Thing: 
            case OWL2_NamedIndividual: {
                this.defineIndividual(st);
                break;
            }
            case OWL_Nothing: {
                this.defineIndividual(st);
                this.kb.addType(st, ATermUtils.BOTTOM);
                break;
            }
            case OWL_ObjectProperty: {
                if (!s.isURI() || this.defineObjectProperty(st)) break;
                this.addUnsupportedFeature("Property " + st + " is defined both as an ObjectProperty and a " + this.kb.getPropertyType((ATerm)st) + "Property");
                break;
            }
            case OWL_DatatypeProperty: {
                if (this.defineDatatypeProperty(st)) break;
                this.addUnsupportedFeature("Property " + st + " is defined both as a DatatypeProperty and a " + this.kb.getPropertyType((ATerm)st) + "Property");
                break;
            }
            case OWL_FunctionalProperty: {
                this.defineProperty(st);
                this.kb.addFunctionalProperty(st);
                this.addSimpleProperty(st, SimpleProperty.CARDINALITY);
                break;
            }
            case OWL_InverseFunctionalProperty: {
                if (this.defineProperty(st)) {
                    this.kb.addInverseFunctionalProperty((ATerm)st);
                    this.addSimpleProperty(st, SimpleProperty.CARDINALITY);
                    break;
                }
                this.addUnsupportedFeature("Ignoring InverseFunctionalProperty axiom for " + st + " (" + this.kb.getPropertyType((ATerm)st) + "Property)");
                break;
            }
            case OWL_TransitiveProperty: {
                if (this.defineObjectProperty(st)) {
                    this.kb.addTransitiveProperty(st);
                    break;
                }
                this.addUnsupportedFeature("Ignoring TransitiveProperty axiom for " + st + " (" + this.kb.getPropertyType((ATerm)st) + "Property)");
                break;
            }
            case OWL_SymmetricProperty: {
                if (this.defineObjectProperty(st)) {
                    this.kb.addSymmetricProperty(st);
                    break;
                }
                this.addUnsupportedFeature("Ignoring SymmetricProperty axiom for " + st + " (" + this.kb.getPropertyType((ATerm)st) + "Property)");
                break;
            }
            case OWL_AnnotationProperty: {
                if (this.defineAnnotationProperty(st)) break;
                this.addUnsupportedFeature("Property " + st + " is defined both as an AnnotationProperty and a " + this.kb.getPropertyType((ATerm)st) + "Property");
                break;
            }
            case OWL2_ReflexiveProperty: {
                if (this.defineObjectProperty(st)) {
                    this.kb.addReflexiveProperty(st);
                    break;
                }
                this.addUnsupportedFeature("Ignoring ReflexiveProperty axiom for " + st + " (" + this.kb.getPropertyType((ATerm)st) + "Property)");
                break;
            }
            case OWL2_IrreflexiveProperty: {
                if (this.defineObjectProperty(st)) {
                    this.kb.addIrreflexiveProperty(st);
                    this.addSimpleProperty(st, SimpleProperty.IRREFLEXIVE);
                    break;
                }
                this.addUnsupportedFeature("Ignoring IrreflexiveProperty axiom for " + st + " (" + this.kb.getPropertyType((ATerm)st) + "Property)");
                break;
            }
            case OWL2_AsymmetricProperty: {
                if (this.defineObjectProperty(st)) {
                    this.kb.addAsymmetricProperty(st);
                    this.addSimpleProperty(st, SimpleProperty.ANTI_SYM);
                    break;
                }
                this.addUnsupportedFeature("Ignoring AntisymmetricProperty axiom for " + st + " (" + this.kb.getPropertyType((ATerm)st) + "Property)");
                break;
            }
            case OWL2_NegativePropertyAssertion: {
                this.addNegatedAssertion(s);
                break;
            }
            case SWRL_Imp: {
                if (!PelletOptions.DL_SAFE_RULES) break;
                this.defineRule(s);
                break;
            }
            case OWL_AllDifferent: 
            case OWL2_AllDisjointClasses: 
            case OWL2_AllDisjointProperties: {
                this.naryDisjoints.put(s, builtinTerm);
                break;
            }
            default: {
                throw new InternalReasonerException("Unexpected term: " + o);
            }
        }
    }

    protected void processTriples() {
        log.fine("processTriples");
        if (this.isLoadABox()) {
            this.processTriples(Node.ANY);
        } else {
            for (Node predicate : TBOX_PREDICATES) {
                this.processTriples(predicate);
            }
        }
    }

    protected void processTriples(Node predicate) {
        ExtendedIterator i = this.graph.find(null, predicate, null);
        while (i.hasNext()) {
            Triple triple = (Triple)i.next();
            this.processTriple(triple);
        }
        i.close();
    }

    protected void processTriple(Triple triple) {
        Node p = triple.getPredicate();
        Node s = triple.getSubject();
        Node o = triple.getObject();
        BuiltinTerm builtinTerm = BuiltinTerm.find(p);
        if (builtinTerm != null) {
            if (builtinTerm.isSyntax()) {
                return;
            }
            if (builtinTerm.equals((Object)BuiltinTerm.RDF_type)) {
                if (BuiltinTerm.find(o) == null) {
                    ATermAppl ot;
                    if (this.isLoadABox() && !AnnotationClasses.contains((ATermAppl)(ot = this.node2term(o)))) {
                        this.defineClass(ot);
                        ATermAppl st = this.node2term(s);
                        this.defineIndividual(st);
                        this.kb.addType(st, ot);
                    }
                } else if (!this.preprocessTypeTriples) {
                    this.processType(triple);
                }
                return;
            }
        }
        this.monitor.incrementProgress();
        ATermAppl st = this.node2term(s);
        ATermAppl ot = this.node2term(o);
        if (builtinTerm == null) {
            BuiltinNamespace builtin;
            String nameSpace;
            PropertyType type;
            ATermAppl pt = this.node2term(p);
            Role role = this.kb.getProperty((ATerm)pt);
            PropertyType propertyType = type = role == null ? PropertyType.UNTYPED : role.getType();
            if (type == PropertyType.ANNOTATION) {
                if (this.graph.contains(s, RDF.type.asNode(), OWL.Ontology.asNode())) {
                    return;
                }
                if (this.defineAnnotationProperty(pt)) {
                    this.kb.addAnnotation(st, pt, ot);
                }
                return;
            }
            if (PelletOptions.FREEZE_BUILTIN_NAMESPACES && (nameSpace = p.getNameSpace()) != null && (builtin = BuiltinNamespace.find((String)nameSpace)) != null) {
                this.addUnsupportedFeature("Ignoring triple with unknown property from " + builtin + " namespace: " + triple);
                return;
            }
            if (o.isLiteral()) {
                if (this.defineDatatypeProperty(pt)) {
                    String datatypeURI = ((ATermAppl)ot.getArgument(2)).getName();
                    if (this.defineIndividual(st)) {
                        this.defineDatatypeProperty(pt);
                        if (!datatypeURI.equals("")) {
                            this.defineDatatype(ATermUtils.makeTermAppl((String)datatypeURI));
                        }
                        this.kb.addPropertyValue(pt, st, ot);
                    } else if (type == PropertyType.UNTYPED) {
                        this.defineAnnotationProperty(pt);
                    } else {
                        this.addUnsupportedFeature("Ignoring ObjectProperty used with a class expression: " + triple);
                    }
                } else {
                    this.addUnsupportedFeature("Ignoring literal value used with ObjectProperty : " + triple);
                }
            } else if (!this.defineObjectProperty(pt)) {
                this.addUnsupportedFeature("Ignoring object value used with DatatypeProperty: " + triple);
            } else if (!this.defineIndividual(st)) {
                this.addUnsupportedFeature("Ignoring class expression used in subject position: " + triple);
            } else if (!this.defineIndividual(ot)) {
                this.addUnsupportedFeature("Ignoring class expression used in object position: " + triple);
            } else {
                this.kb.addPropertyValue(pt, st, ot);
            }
            return;
        }
        switch (builtinTerm) {
            case RDFS_subClassOf: {
                if (!this.defineClass(st)) {
                    this.addUnsupportedFeature("Ignoring subClassOf axiom because the subject is not a class " + st + " rdfs:subClassOf " + ot);
                    break;
                }
                if (!this.defineClass(ot)) {
                    this.addUnsupportedFeature("Ignoring subClassOf axiom because the object is not a class " + st + " rdfs:subClassOf " + ot);
                    break;
                }
                this.kb.addSubClass(st, ot);
                break;
            }
            case RDFS_subPropertyOf: {
                ATermAppl subProp = null;
                if (s.isBlank()) {
                    Triple expr = this.getExpression(s);
                    if (expr == null) {
                        this.addUnsupportedFeature("Bnode in rdfs:subProperty axioms is not a valid property expression");
                    } else if (expr.getPredicate().equals((Object)OWL2.inverseOf.asNode())) {
                        if (this.defineObjectProperty((ATermAppl)st.getArgument(0)) && this.defineObjectProperty(ot)) {
                            subProp = st;
                        }
                    } else if (expr.getPredicate().equals((Object)OWL2.propertyChain.asNode())) {
                        subProp = this.createList(expr.getObject());
                        ATermList list = (ATermList)subProp;
                        while (!list.isEmpty() && this.defineObjectProperty((ATermAppl)list.getFirst())) {
                            list = list.getNext();
                        }
                        if (!list.isEmpty() || !this.defineObjectProperty(ot)) {
                            subProp = null;
                        }
                    } else {
                        this.addUnsupportedFeature("Bnode in rdfs:subProperty axioms is not a valid property expression");
                    }
                } else if (this.defineProperties(st, ot)) {
                    subProp = st;
                }
                if (subProp != null) {
                    this.kb.addSubProperty((ATerm)subProp, ot);
                    break;
                }
                this.addUnsupportedFeature("Ignoring subproperty axiom between " + st + " (" + this.kb.getPropertyType((ATerm)st) + "Property) and " + ot + " (" + this.kb.getPropertyType((ATerm)ot) + "Property)");
                break;
            }
            case RDFS_domain: {
                if (this.kb.isAnnotationProperty((ATerm)st)) {
                    this.addUnsupportedFeature("Ignoring domain axiom for AnnotationProperty " + st);
                    break;
                }
                this.defineProperty(st);
                this.defineClass(ot);
                this.kb.addDomain((ATerm)st, ot);
                break;
            }
            case RDFS_range: {
                if (this.kb.isAnnotationProperty((ATerm)st)) {
                    this.addUnsupportedFeature("Ignoring range axiom for AnnotationProperty " + st);
                    break;
                }
                if (this.kb.isDatatype(ot)) {
                    this.defineDatatypeProperty(st);
                } else if (this.kb.isClass((ATerm)ot)) {
                    this.defineObjectProperty(st);
                } else {
                    this.defineProperty(st);
                }
                if (this.kb.isDatatypeProperty((ATerm)st)) {
                    this.defineDatatype(ot);
                } else if (this.kb.isObjectProperty((ATerm)st)) {
                    this.defineClass(ot);
                }
                this.kb.addRange((ATerm)st, ot);
                break;
            }
            case OWL_intersectionOf: {
                ATermList list = this.createList(o);
                this.defineClass(st);
                ATermAppl conjunction = ATermUtils.makeAnd((ATermList)list);
                this.kb.addEquivalentClass(st, conjunction);
                break;
            }
            case OWL_unionOf: {
                ATermList list = this.createList(o);
                this.defineClass(st);
                ATermAppl disjunction = ATermUtils.makeOr((ATermList)list);
                this.kb.addEquivalentClass(st, disjunction);
                break;
            }
            case OWL2_disjointUnionOf: {
                ATermList list = this.createList(o);
                this.kb.addDisjointClasses(list);
                this.defineClass(st);
                ATermAppl disjunction = ATermUtils.makeOr((ATermList)list);
                this.kb.addEquivalentClass(st, disjunction);
                break;
            }
            case OWL_complementOf: {
                if (!this.defineClass(st)) {
                    this.addUnsupportedFeature("Ignoring complementOf axiom because the subject is not a class " + st + " owl:complementOf " + ot);
                    break;
                }
                if (!this.defineClass(ot)) {
                    this.addUnsupportedFeature("Ignoring complementOf axiom because the object is not a class " + st + " owl:complementOf " + ot);
                    break;
                }
                this.kb.addComplementClass(st, ot);
                break;
            }
            case OWL_equivalentClass: {
                if (this.kb.isDatatype(ot) || this.anonDatatypes.contains(o)) {
                    if (!this.defineDatatype(st)) {
                        this.addUnsupportedFeature("Ignoring equivalentClass axiom because the subject is not a datatype " + st + " owl:equivalentClass " + ot);
                        break;
                    }
                    this.kb.addDatatypeDefinition(st, ot);
                    break;
                }
                if (!this.defineClass(st)) {
                    this.addUnsupportedFeature("Ignoring equivalentClass axiom because the subject is not a class " + st + " owl:equivalentClass " + ot);
                    break;
                }
                if (!this.defineClass(ot)) {
                    this.addUnsupportedFeature("Ignoring equivalentClass axiom because the object is not a class " + st + " owl:equivalentClass " + ot);
                    break;
                }
                this.kb.addEquivalentClass(st, ot);
                break;
            }
            case OWL_disjointWith: {
                if (!this.defineClass(st)) {
                    this.addUnsupportedFeature("Ignoring disjointWith axiom because the subject is not a class " + st + " owl:disjointWith " + ot);
                    break;
                }
                if (!this.defineClass(ot)) {
                    this.addUnsupportedFeature("Ignoring disjointWith axiom because the object is not a class " + st + " owl:disjointWith " + ot);
                    break;
                }
                this.kb.addDisjointClass(st, ot);
                break;
            }
            case OWL2_propertyDisjointWith: {
                if (this.defineProperties(st, ot)) {
                    this.kb.addDisjointProperty(st, ot);
                    this.addSimpleProperty(st, SimpleProperty.DISJOINT);
                    this.addSimpleProperty(ot, SimpleProperty.DISJOINT);
                    break;
                }
                this.addUnsupportedFeature("Ignoring disjoint property axiom between " + st + " (" + this.kb.getPropertyType((ATerm)st) + "Property) and " + ot + " (" + this.kb.getPropertyType((ATerm)ot) + "Property)");
                break;
            }
            case OWL2_propertyChainAxiom: {
                ATermList subProp;
                ATermAppl superProp = null;
                if (s.isBlank()) {
                    Triple expr = this.getExpression(s);
                    if (expr == null) {
                        this.addUnsupportedFeature("Bnode in owl:propertyChainAxiom axiom is not a valid property expression");
                    } else if (expr.getPredicate().equals((Object)OWL2.inverseOf.asNode())) {
                        if (this.defineObjectProperty((ATermAppl)st.getArgument(0))) {
                            superProp = st;
                        }
                    } else {
                        this.addUnsupportedFeature("Bnode in owl:propertyChainAxiom axiom is not a valid property expression");
                    }
                } else if (this.defineObjectProperty(st)) {
                    superProp = st;
                }
                ATermList list = subProp = this.createList(o);
                while (!list.isEmpty() && this.defineObjectProperty((ATermAppl)list.getFirst())) {
                    list = list.getNext();
                }
                if (!list.isEmpty()) {
                    subProp = null;
                }
                if (subProp != null && superProp != null) {
                    this.kb.addSubProperty((ATerm)subProp, superProp);
                    break;
                }
                this.addUnsupportedFeature("Ignoring property chain axiom between " + st + " (" + this.kb.getPropertyType((ATerm)st) + "Property) and " + ot);
                break;
            }
            case OWL_equivalentProperty: {
                if (this.defineProperties(st, ot)) {
                    this.kb.addEquivalentProperty(st, ot);
                    break;
                }
                this.addUnsupportedFeature("Ignoring equivalent property axiom between " + st + " (" + this.kb.getPropertyType((ATerm)st) + "Property) and " + ot + " (" + this.kb.getPropertyType((ATerm)ot) + "Property)");
                break;
            }
            case OWL_inverseOf: {
                if (this.defineObjectProperty(st) && this.defineObjectProperty(ot)) {
                    this.kb.addInverseProperty(st, ot);
                    break;
                }
                this.addUnsupportedFeature("Ignoring inverseOf axiom between " + st + " (" + this.kb.getPropertyType((ATerm)st) + "Property) and " + ot + " (" + this.kb.getPropertyType((ATerm)ot) + "Property)");
                break;
            }
            case OWL_sameAs: {
                if (this.defineIndividual(st) && this.defineIndividual(ot)) {
                    this.kb.addSame(st, ot);
                    break;
                }
                this.addUnsupportedFeature("Ignoring sameAs axiom between " + st + " and " + ot);
                break;
            }
            case OWL_differentFrom: {
                if (this.defineIndividual(st) && this.defineIndividual(ot)) {
                    this.kb.addDifferent(st, ot);
                    break;
                }
                this.addUnsupportedFeature("Ignoring differentFrom axiom between " + st + " and " + ot);
                break;
            }
            case OWL_distinctMembers: {
                ATermList list;
                ATermList l = list = this.createList(o);
                while (!l.isEmpty()) {
                    ATermAppl c = (ATermAppl)l.getFirst();
                    this.defineIndividual(c);
                    l = l.getNext();
                }
                this.kb.addAllDifferent(list);
                break;
            }
            case OWL_members: {
                ATermList list;
                BuiltinTerm entityType = null;
                if (this.preprocessTypeTriples) {
                    entityType = this.naryDisjoints.get(s);
                } else {
                    Node type = this.getObject(s, RDF.type.asNode());
                    if (type != null) {
                        entityType = BuiltinTerm.find(type);
                    }
                }
                if (entityType == null) {
                    this.addUnsupportedFeature("There is no valid rdf:type for an owl:members assertion: " + s);
                    break;
                }
                if (!OWL_MEMBERS_TYPES.contains((Object)entityType)) {
                    this.addUnsupportedFeature("The rdf:type for an owl:members assertion is not recognized: " + (Object)((Object)entityType));
                    break;
                }
                ATermList l = list = this.createList(o);
                while (!l.isEmpty()) {
                    ATermAppl c = (ATermAppl)l.getFirst();
                    switch (entityType) {
                        case OWL_AllDifferent: {
                            this.defineIndividual(c);
                            break;
                        }
                        case OWL2_AllDisjointClasses: {
                            this.defineClass(c);
                            break;
                        }
                        case OWL2_AllDisjointProperties: {
                            this.defineProperty(c);
                        }
                    }
                    l = l.getNext();
                }
                switch (entityType) {
                    case OWL_AllDifferent: {
                        this.kb.addAllDifferent(list);
                        break;
                    }
                    case OWL2_AllDisjointClasses: {
                        this.kb.addDisjointClasses(list);
                        break;
                    }
                    case OWL2_AllDisjointProperties: {
                        this.kb.addDisjointProperties(list);
                    }
                }
                break;
            }
            case OWL_oneOf: {
                ATermList resultList = ATermUtils.EMPTY_LIST;
                if (this.kb.isDatatype(st)) {
                    return;
                }
                this.defineClass(st);
                ATermAppl disjunction = null;
                ATermList list = this.createList(o);
                if (o.equals((Object)RDF.nil.asNode())) {
                    disjunction = ATermUtils.BOTTOM;
                } else {
                    ATermList l = list;
                    while (!l.isEmpty()) {
                        ATermAppl c = (ATermAppl)l.getFirst();
                        if (PelletOptions.USE_PSEUDO_NOMINALS) {
                            ATermAppl nominal = ATermUtils.makeTermAppl((String)(c.getName() + "_nominal"));
                            resultList = resultList.insert((ATerm)nominal);
                            this.defineClass(nominal);
                            this.defineIndividual(c);
                            this.kb.addType(c, nominal);
                        } else {
                            this.defineIndividual(c);
                            resultList = resultList.insert((ATerm)ATermUtils.makeValue((ATerm)c));
                        }
                        l = l.getNext();
                    }
                    disjunction = ATermUtils.makeOr((ATermList)resultList);
                }
                this.kb.addEquivalentClass(st, disjunction);
                break;
            }
            case OWL2_hasKey: {
                ATermList list;
                if (o.equals((Object)RDF.nil.asNode())) {
                    return;
                }
                HashSet<ATermAppl> properties = new HashSet<ATermAppl>();
                this.defineClass(st);
                ATermList l = list = this.createList(o);
                while (!l.isEmpty()) {
                    ATermAppl f = (ATermAppl)l.getFirst();
                    this.defineProperty(f);
                    properties.add(f);
                    l = l.getNext();
                }
                this.kb.addKey(st, properties);
                break;
            }
            case OWL2_topDataProperty: 
            case OWL2_bottomDataProperty: 
            case OWL2_topObjectProperty: 
            case OWL2_bottomObjectProperty: {
                this.defineIndividual(st);
                this.kb.addPropertyValue(this.node2term(p), st, ot);
                break;
            }
            default: {
                throw new InternalReasonerException("Unrecognized term: " + p);
            }
        }
    }

    protected void processUntypedResources() {
        log.fine("processUntypedResource");
        for (Role r : this.kb.getRBox().getRoles().toArray(new Role[0])) {
            Set ranges;
            SimpleProperty why = this.simpleProperties.get(r.getName());
            if (why != null) {
                String msg = null;
                if (r.isTransitive()) {
                    msg = "transitivity axiom";
                } else if (r.hasComplexSubRole()) {
                    msg = "complex sub property axiom";
                }
                if (msg != null) {
                    msg = "Ignoring " + msg + " due to an existing " + (Object)((Object)why) + " for property " + r;
                    this.addUnsupportedFeature(msg);
                    r.removeSubRoleChains();
                }
            }
            if (!r.isUntypedRole()) continue;
            boolean rangeToDatatype = false;
            Set roles = SetUtils.union((Collection)r.getSubRoles(), (Collection)r.getSuperRoles());
            block5: for (Role sub : roles) {
                switch (sub.getType()) {
                    case OBJECT: {
                        this.defineObjectProperty(r.getName());
                        continue block5;
                    }
                    case DATATYPE: {
                        this.defineDatatypeProperty(r.getName());
                        rangeToDatatype = true;
                        continue block5;
                    }
                }
            }
            if (!rangeToDatatype) {
                this.defineObjectProperty(r.getName());
            }
            if ((ranges = r.getRanges()) == null) continue;
            if (rangeToDatatype) {
                for (ATermAppl range : ranges) {
                    if (range.getAFun().getArity() != 0 || this.kb.isDatatype(range)) continue;
                    this.defineDatatype(range);
                }
                continue;
            }
            for (ATermAppl range : ranges) {
                if (range.getAFun().getArity() != 0 || this.kb.isClass((ATerm)range)) continue;
                this.defineClass(range);
            }
        }
    }

    @Override
    public void setKB(KnowledgeBase kb) {
        this.kb = kb;
    }

    private void defineBuiltinProperties() {
        this.defineAnnotationProperty(this.node2term(RDFS.label.asNode()));
        this.defineAnnotationProperty(this.node2term(RDFS.comment.asNode()));
        this.defineAnnotationProperty(this.node2term(RDFS.seeAlso.asNode()));
        this.defineAnnotationProperty(this.node2term(RDFS.isDefinedBy.asNode()));
        this.defineAnnotationProperty(this.node2term(OWL.versionInfo.asNode()));
        this.defineAnnotationProperty(this.node2term(OWL.backwardCompatibleWith.asNode()));
        this.defineAnnotationProperty(this.node2term(OWL.priorVersion.asNode()));
        this.defineAnnotationProperty(this.node2term(OWL.incompatibleWith.asNode()));
    }

    @Override
    public void load(Iterable<Graph> graphs) throws UnsupportedFeatureException {
        Graph g;
        Timer timer = this.kb.timers.startTimer("load");
        this.monitor.setProgressTitle("Loading");
        this.monitor.taskStarted();
        this.graph = EMPTY_GRAPH;
        this.preprocess();
        Iterator<Graph> iterator = graphs.iterator();
        while (iterator.hasNext()) {
            this.graph = g = iterator.next();
            this.processTypes();
        }
        iterator = graphs.iterator();
        while (iterator.hasNext()) {
            this.graph = g = iterator.next();
            this.processTriples();
        }
        this.processUntypedResources();
        this.monitor.taskFinished();
        timer.stop();
    }

    @Override
    public void preprocess() {
        this.defineBuiltinProperties();
    }

    @Override
    public boolean isLoadABox() {
        return this.loadABox;
    }

    @Override
    public void setLoadABox(boolean loadABox) {
        this.loadABox = loadABox;
    }

    @Override
    public boolean isLoadTBox() {
        return this.loadTBox;
    }

    @Override
    public void setLoadTBox(boolean loadTBox) {
        this.loadTBox = loadTBox;
    }

    @Override
    public boolean isPreprocessTypeTriples() {
        return this.preprocessTypeTriples;
    }

    @Override
    public void setPreprocessTypeTriples(boolean preprocessTypeTriples) {
        this.preprocessTypeTriples = preprocessTypeTriples;
    }

    static {
        ArrayList<Node> predicates = new ArrayList<Node>();
        ArrayList<Node> types = new ArrayList<Node>();
        for (BuiltinTerm builtinTerm : BuiltinTerm.values()) {
            if (builtinTerm.isABox() || builtinTerm.isSyntax()) continue;
            if (builtinTerm.isPredicate()) {
                predicates.add(builtinTerm.getNode());
                continue;
            }
            types.add(builtinTerm.getNode());
        }
        TBOX_PREDICATES = predicates.toArray(new Node[predicates.size()]);
        TBOX_TYPES = types.toArray(new Node[types.size()]);
        OWL_MEMBERS_TYPES = EnumSet.of(BuiltinTerm.OWL_AllDifferent, BuiltinTerm.OWL2_AllDisjointClasses, BuiltinTerm.OWL2_AllDisjointProperties);
        EMPTY_GRAPH = Factory.createGraphMem();
        qnames = new QNameProvider();
    }

    private class RDFListIterator
    implements Iterator<Node> {
        private Node list;

        public RDFListIterator(Node list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return !this.list.equals((Object)RDF.nil.asNode());
        }

        @Override
        public Node next() {
            Node first = DefaultGraphLoader.this.getFirst(this.list);
            DefaultGraphLoader.this.monitor.incrementProgress();
            Node rest = DefaultGraphLoader.this.getRest(this.list);
            DefaultGraphLoader.this.monitor.incrementProgress();
            if (first == null || rest == null) {
                DefaultGraphLoader.this.addUnsupportedFeature("Invalid list structure: List " + this.list + " does not have a " + (first == null ? "rdf:first" : "rdf:rest") + " property. Ignoring rest of the list.");
                return null;
            }
            this.list = rest;
            return first;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

