/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.util.iterator.Filter;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.ReasonerVocabulary;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public class ModelExtractor {
    public static final Filter<Triple> FILTER_NONE = new Filter<Triple>(){

        public boolean accept(Triple o) {
            return false;
        }
    };
    private KnowledgeBase kb;
    private Filter<Triple> filter = FILTER_NONE;
    private EnumSet<StatementType> selector = StatementType.DEFAULT_STATEMENTS;

    public ModelExtractor() {
    }

    public ModelExtractor(Model model) throws ClassCastException {
        this((PelletInfGraph)model.getGraph());
    }

    public ModelExtractor(PelletInfGraph graph) {
        this(graph.getPreparedKB());
    }

    public ModelExtractor(KnowledgeBase kb) {
        this.setKB(kb);
    }

    private void addTriple(List<Triple> triples, Node s, Node p, Node o) {
        Triple triple = Triple.create((Node)s, (Node)p, (Node)o);
        if (!this.filter.accept((Object)triple)) {
            triples.add(triple);
        }
    }

    public Model extractClassModel() {
        return this.extractClassModel(ModelFactory.createDefaultModel());
    }

    public Model extractClassModel(Model model) {
        boolean allSubs = this.selector.contains((Object)StatementType.ALL_SUBCLASS);
        boolean jenaDirectSubs = this.selector.contains((Object)StatementType.JENA_DIRECT_SUBCLASS);
        boolean subs = allSubs || jenaDirectSubs || this.selector.contains((Object)StatementType.DIRECT_SUBCLASS);
        boolean equivs = this.selector.contains((Object)StatementType.EQUIVALENT_CLASS);
        boolean disjs = this.selector.contains((Object)StatementType.DISJOINT_CLASS);
        boolean comps = this.selector.contains((Object)StatementType.COMPLEMENT_CLASS);
        if (subs || equivs || disjs || comps) {
            this.kb.classify();
        }
        ArrayList<Triple> triples = new ArrayList<Triple>();
        Set classes = this.kb.getAllClasses();
        for (ATermAppl c : classes) {
            Set comp;
            Set disj;
            Iterator i;
            Node o;
            Set eqs;
            Node p;
            triples.clear();
            Node s = JenaUtils.makeGraphNode(c);
            this.addTriple(triples, s, RDF.type.asNode(), OWL.Class.asNode());
            if (subs) {
                p = RDFS.subClassOf.asNode();
                if (allSubs) {
                    eqs = this.kb.getAllEquivalentClasses(c);
                    for (ATermAppl eq : eqs) {
                        o = JenaUtils.makeGraphNode(eq);
                        this.addTriple(triples, s, p, o);
                    }
                }
                Set supers = allSubs ? this.kb.getSuperClasses(c, false) : this.kb.getSuperClasses(c, true);
                i = IteratorUtils.flatten(supers.iterator());
                while (i.hasNext()) {
                    Node o2 = JenaUtils.makeGraphNode((ATermAppl)i.next());
                    this.addTriple(triples, s, p, o2);
                }
                if (jenaDirectSubs) {
                    p = ReasonerVocabulary.directSubClassOf.asNode();
                    Set direct = allSubs ? this.kb.getSuperClasses(c, true) : supers;
                    i = IteratorUtils.flatten(direct.iterator());
                    while (i.hasNext()) {
                        o = JenaUtils.makeGraphNode((ATermAppl)i.next());
                        this.addTriple(triples, s, p, o);
                    }
                }
            }
            if (equivs) {
                p = OWL.equivalentClass.asNode();
                eqs = this.kb.getAllEquivalentClasses(c);
                for (ATermAppl a : eqs) {
                    o = JenaUtils.makeGraphNode(a);
                    this.addTriple(triples, s, p, o);
                }
            }
            if (disjs && !(disj = this.kb.getDisjointClasses(c)).isEmpty()) {
                p = OWL.disjointWith.asNode();
                i = IteratorUtils.flatten(disj.iterator());
                while (i.hasNext()) {
                    ATermAppl a;
                    a = (ATermAppl)i.next();
                    if (!classes.contains(a)) continue;
                    this.addTriple(triples, s, p, JenaUtils.makeGraphNode(a));
                }
            }
            if (comps && !(comp = this.kb.getComplements(c)).isEmpty()) {
                p = OWL.complementOf.asNode();
                for (ATermAppl a : comp) {
                    if (!classes.contains(a)) continue;
                    this.addTriple(triples, s, p, JenaUtils.makeGraphNode(a));
                }
            }
            for (Triple t : triples) {
                model.getGraph().add(t);
            }
        }
        return model;
    }

    public Model extractIndividualModel() {
        return this.extractIndividualModel(ModelFactory.createDefaultModel());
    }

    public Model extractIndividualModel(Model model) {
        boolean allClasses = this.selector.contains((Object)StatementType.ALL_INSTANCE);
        boolean jenaDirectClasses = this.selector.contains((Object)StatementType.JENA_DIRECT_INSTANCE);
        boolean classes = allClasses || jenaDirectClasses || this.selector.contains((Object)StatementType.DIRECT_INSTANCE);
        boolean sames = this.selector.contains((Object)StatementType.SAME_AS);
        boolean diffs = this.selector.contains((Object)StatementType.DIFFERENT_FROM);
        boolean objValues = this.selector.contains((Object)StatementType.OBJECT_PROPERTY_VALUE);
        boolean dataValues = this.selector.contains((Object)StatementType.DATA_PROPERTY_VALUE);
        if (classes) {
            this.kb.realize();
        }
        ArrayList<Triple> triples = new ArrayList<Triple>();
        for (ATermAppl ind : this.kb.getIndividuals()) {
            Node p;
            triples.clear();
            Node s = JenaUtils.makeGraphNode(ind);
            if (classes) {
                p = RDF.type.asNode();
                Set types = this.kb.getTypes(ind, !allClasses);
                Iterator i = IteratorUtils.flatten(types.iterator());
                while (i.hasNext()) {
                    Node o = JenaUtils.makeGraphNode((ATermAppl)i.next());
                    this.addTriple(triples, s, p, o);
                }
                if (jenaDirectClasses) {
                    p = ReasonerVocabulary.directRDFType.asNode();
                    Set directTypes = allClasses ? this.kb.getTypes(ind, true) : types;
                    i = IteratorUtils.flatten(directTypes.iterator());
                    while (i.hasNext()) {
                        Node o = JenaUtils.makeGraphNode((ATermAppl)i.next());
                        this.addTriple(triples, s, p, o);
                    }
                }
            }
            if (sames) {
                p = OWL.sameAs.asNode();
                this.addTriple(triples, s, p, s);
                for (ATermAppl a : this.kb.getSames(ind)) {
                    this.addTriple(triples, s, p, JenaUtils.makeGraphNode(a));
                }
            }
            if (diffs) {
                p = OWL.differentFrom.asNode();
                for (ATermAppl a : this.kb.getDifferents(ind)) {
                    this.addTriple(triples, s, p, JenaUtils.makeGraphNode(a));
                }
            }
            if (dataValues || objValues) {
                for (Role role : this.kb.getRBox().getRoles()) {
                    List values;
                    if (role.isAnon()) continue;
                    ATermAppl name = role.getName();
                    if (role.isDatatypeRole()) {
                        if (!dataValues) continue;
                        values = this.kb.getDataPropertyValues(name, ind);
                    } else {
                        if (!role.isObjectRole() || !objValues) continue;
                        values = this.kb.getObjectPropertyValues(name, ind);
                    }
                    if (values.isEmpty()) continue;
                    p = JenaUtils.makeGraphNode(name);
                    for (ATermAppl value : values) {
                        this.addTriple(triples, s, p, JenaUtils.makeGraphNode(value));
                    }
                }
            }
            for (Triple t : triples) {
                model.getGraph().add(t);
            }
        }
        return model;
    }

    public Model extractModel() {
        return this.extractModel(ModelFactory.createDefaultModel());
    }

    public Model extractModel(Model model) {
        this.extractClassModel(model);
        this.extractPropertyModel(model);
        this.extractIndividualModel(model);
        return model;
    }

    public Model extractPropertyModel() {
        return this.extractPropertyModel(ModelFactory.createDefaultModel());
    }

    public Model extractPropertyModel(Model model) {
        boolean allSubs = this.selector.contains((Object)StatementType.ALL_SUBPROPERTY);
        boolean jenaDirectSubs = this.selector.contains((Object)StatementType.JENA_DIRECT_SUBPROPERTY);
        boolean subs = allSubs || jenaDirectSubs || this.selector.contains((Object)StatementType.DIRECT_SUBPROPERTY);
        boolean equivs = this.selector.contains((Object)StatementType.EQUIVALENT_PROPERTY);
        boolean invs = this.selector.contains((Object)StatementType.INVERSE_PROPERTY);
        boolean disjs = this.selector.contains((Object)StatementType.DISJOINT_PROPERTY);
        this.kb.prepare();
        ArrayList<Triple> triples = new ArrayList<Triple>();
        for (Role role : this.kb.getRBox().getRoles()) {
            Iterator i;
            Set disjoints;
            Set inverses;
            Node o;
            triples.clear();
            if (role.isAnon()) continue;
            ATermAppl name = role.getName();
            Node s = JenaUtils.makeGraphNode(name);
            Node p = RDF.type.asNode();
            if (role.isDatatypeRole()) {
                this.addTriple(triples, s, p, OWL.DatatypeProperty.asNode());
            } else {
                if (!role.isObjectRole()) continue;
                this.addTriple(triples, s, p, OWL.ObjectProperty.asNode());
            }
            if (role.isFunctional()) {
                this.addTriple(triples, s, p, OWL.FunctionalProperty.asNode());
            }
            if (role.isInverseFunctional()) {
                this.addTriple(triples, s, p, OWL.InverseFunctionalProperty.asNode());
            }
            if (role.isTransitive()) {
                this.addTriple(triples, s, p, OWL.TransitiveProperty.asNode());
            }
            if (role.isSymmetric()) {
                this.addTriple(triples, s, p, OWL.SymmetricProperty.asNode());
            }
            if (equivs) {
                p = OWL.equivalentProperty.asNode();
                for (Object eq : this.kb.getAllEquivalentProperties(name)) {
                    o = JenaUtils.makeGraphNode((ATermAppl)eq);
                    this.addTriple(triples, s, p, o);
                    if (!allSubs) continue;
                    this.addTriple(triples, s, RDFS.subPropertyOf.asNode(), o);
                }
            }
            if (invs && !(inverses = this.kb.getInverses((ATerm)name)).isEmpty()) {
                Object eq;
                p = OWL.inverseOf.asNode();
                eq = inverses.iterator();
                while (eq.hasNext()) {
                    ATermAppl inverse = (ATermAppl)eq.next();
                    this.addTriple(triples, s, p, JenaUtils.makeGraphNode(inverse));
                }
            }
            if (disjs && !(disjoints = this.kb.getDisjointProperties(name)).isEmpty()) {
                p = OWL2.propertyDisjointWith.asNode();
                i = IteratorUtils.flatten(disjoints.iterator());
                while (i.hasNext()) {
                    o = JenaUtils.makeGraphNode((ATermAppl)i.next());
                    this.addTriple(triples, s, p, o);
                }
            }
            if (subs) {
                Set supers;
                Node o2;
                p = RDFS.subPropertyOf.asNode();
                if (allSubs) {
                    Set eqs = this.kb.getAllEquivalentProperties(name);
                    for (ATermAppl eq : eqs) {
                        o2 = JenaUtils.makeGraphNode(eq);
                        this.addTriple(triples, s, p, o2);
                    }
                }
                if (!(supers = this.kb.getSuperProperties(name, !allSubs)).isEmpty()) {
                    i = IteratorUtils.flatten(supers.iterator());
                    while (i.hasNext()) {
                        o = JenaUtils.makeGraphNode((ATermAppl)i.next());
                        this.addTriple(triples, s, p, o);
                    }
                    if (jenaDirectSubs) {
                        p = ReasonerVocabulary.directSubPropertyOf.asNode();
                        Set direct = allSubs ? this.kb.getSuperProperties(name, true) : supers;
                        i = IteratorUtils.flatten(direct.iterator());
                        while (i.hasNext()) {
                            o2 = JenaUtils.makeGraphNode((ATermAppl)i.next());
                            this.addTriple(triples, s, p, o2);
                        }
                    }
                }
            }
            for (Triple t : triples) {
                model.getGraph().add(t);
            }
        }
        return model;
    }

    public EnumSet<StatementType> getSelector() {
        return this.selector;
    }

    public void setSelector(EnumSet<StatementType> selector) {
        this.selector = selector;
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public void setKB(KnowledgeBase kb) {
        this.kb = kb;
    }

    public Filter<Triple> getFilter() {
        return this.filter;
    }

    public void setFilter(Filter<Triple> filter) {
        if (filter == null) {
            throw new NullPointerException("Filter cannot be null");
        }
        this.filter = filter;
    }

    public static enum StatementType {
        ALL_INSTANCE,
        ALL_SUBCLASS,
        ALL_SUBPROPERTY,
        COMPLEMENT_CLASS,
        DATA_PROPERTY_VALUE,
        DIFFERENT_FROM,
        DIRECT_INSTANCE,
        DIRECT_SUBCLASS,
        DIRECT_SUBPROPERTY,
        DISJOINT_CLASS,
        DISJOINT_PROPERTY,
        EQUIVALENT_CLASS,
        EQUIVALENT_PROPERTY,
        INVERSE_PROPERTY,
        JENA_DIRECT_INSTANCE,
        JENA_DIRECT_SUBCLASS,
        JENA_DIRECT_SUBPROPERTY,
        OBJECT_PROPERTY_VALUE,
        SAME_AS;

        public static final EnumSet<StatementType> ALL_CLASS_STATEMENTS;
        public static final EnumSet<StatementType> ALL_INDIVIDUAL_STATEMENTS;
        public static final EnumSet<StatementType> ALL_PROPERTY_STATEMENTS;
        public static final EnumSet<StatementType> ALL_STATEMENTS;
        public static final EnumSet<StatementType> ALL_STATEMENTS_INCLUDING_JENA;
        public static final EnumSet<StatementType> PROPERTY_VALUE;
        public static final EnumSet<StatementType> DEFAULT_STATEMENTS;

        static {
            ALL_CLASS_STATEMENTS = EnumSet.of(ALL_SUBCLASS, COMPLEMENT_CLASS, DIRECT_SUBCLASS, DISJOINT_CLASS, EQUIVALENT_CLASS);
            ALL_INDIVIDUAL_STATEMENTS = EnumSet.of(ALL_INSTANCE, new StatementType[]{DATA_PROPERTY_VALUE, DIFFERENT_FROM, DIRECT_INSTANCE, OBJECT_PROPERTY_VALUE, SAME_AS});
            ALL_PROPERTY_STATEMENTS = EnumSet.of(ALL_SUBPROPERTY, DIRECT_SUBPROPERTY, EQUIVALENT_PROPERTY, INVERSE_PROPERTY, DISJOINT_PROPERTY);
            ALL_STATEMENTS = EnumSet.complementOf(EnumSet.of(JENA_DIRECT_INSTANCE, JENA_DIRECT_SUBCLASS, JENA_DIRECT_SUBPROPERTY));
            ALL_STATEMENTS_INCLUDING_JENA = EnumSet.allOf(StatementType.class);
            DEFAULT_STATEMENTS = EnumSet.of(DIRECT_SUBCLASS, new StatementType[]{EQUIVALENT_CLASS, DIRECT_INSTANCE, OBJECT_PROPERTY_VALUE, DATA_PROPERTY_VALUE, DIRECT_SUBPROPERTY, EQUIVALENT_PROPERTY, INVERSE_PROPERTY});
            PROPERTY_VALUE = EnumSet.of(DATA_PROPERTY_VALUE, OBJECT_PROPERTY_VALUE);
        }
    }
}

