/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.jena;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.QueryParameters;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.mindswap.pellet.jena.JenaUtils;

public class SparqlDLResultSet
implements ResultSetRewindable {
    private Model model;
    private List<ATermAppl> resultVars;
    private List<String> resultVarsString;
    private QueryResult queryResult;
    private int index;
    private Iterator<ResultBinding> bindings;
    private Binding parent;
    private QueryParameters parameters;

    public SparqlDLResultSet(QueryResult answers, Model model) {
        this(answers, model, null, null);
    }

    public SparqlDLResultSet(QueryResult answers, Model model, Binding parent) {
        this(answers, model, parent, null);
    }

    public SparqlDLResultSet(QueryResult answers, Model model, QueryParameters parameters) {
        this(answers, model, null, parameters);
    }

    public SparqlDLResultSet(QueryResult answers, Model model, Binding parent, QueryParameters parameters) {
        this.parent = parent;
        this.queryResult = answers;
        this.model = model;
        this.parameters = parameters;
        this.index = 0;
        this.bindings = answers.iterator();
        this.resultVars = new ArrayList<ATermAppl>();
        this.resultVarsString = new ArrayList<String>();
        for (ATermAppl var : this.queryResult.getResultVars()) {
            this.resultVars.add(var);
            this.resultVarsString.add(this.getVarName(var));
        }
        if (parameters == null) {
            this.parameters = new QueryParameters();
        }
    }

    protected String getVarName(ATermAppl term) {
        return ((ATermAppl)term.getArgument(0)).getName();
    }

    public QueryResult getQueryResult() {
        return this.queryResult;
    }

    public boolean hasNext() {
        return this.bindings.hasNext();
    }

    public Binding nextBinding() {
        ++this.index;
        ResultBinding binding = this.bindings.next();
        BindingHashMap result = this.parent == null ? new BindingHashMap() : new BindingHashMap(this.parent);
        for (ATermAppl var : this.resultVars) {
            if (!binding.isBound(var)) continue;
            String varName = this.getVarName(var);
            ATermAppl value = binding.getValue(var);
            if (value == null) continue;
            Node node = JenaUtils.makeGraphNode((ATermAppl)value);
            result.add(Var.alloc((String)varName), node);
        }
        if (this.resultVars.size() == 0) {
            for (Map.Entry entry : this.parameters.entrySet()) {
                ATermAppl term = (ATermAppl)entry.getKey();
                String varName = this.getVarName(term);
                Var var = Var.alloc((String)varName);
                if (result.contains(var)) continue;
                result.add(var, JenaUtils.makeGraphNode((ATermAppl)((ATermAppl)entry.getValue())));
            }
        }
        return result;
    }

    public QuerySolution nextSolution() {
        return new org.apache.jena.sparql.core.ResultBinding(this.model, this.nextBinding());
    }

    public QuerySolution next() {
        return this.nextSolution();
    }

    public boolean isDistinct() {
        return this.queryResult.isDistinct();
    }

    public boolean isOrdered() {
        return false;
    }

    public int getRowNumber() {
        return this.index;
    }

    public List<String> getResultVars() {
        return Collections.unmodifiableList(this.resultVarsString);
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Remove not supported");
    }

    public String toString() {
        return this.queryResult.toString();
    }

    public void reset() {
        this.index = 0;
        this.bindings = this.queryResult.iterator();
    }

    public int size() {
        return this.queryResult.size();
    }

    public Model getResourceModel() {
        return this.model;
    }
}

