/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.jena;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.SortCondition;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.ResultBinding;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingComparator;

public class SortedResultSet
implements ResultSet {
    private List<Binding> sortedRows;
    private Iterator<Binding> iterator;
    private int row;
    private List<String> resultVars;

    public SortedResultSet(ResultSet results, List<SortCondition> sortConditions) {
        this.resultVars = results.getResultVars();
        this.sortedRows = new ArrayList<Binding>();
        while (results.hasNext()) {
            this.sortedRows.add(results.nextBinding());
        }
        BindingComparator cmp = new BindingComparator(sortConditions);
        Collections.sort(this.sortedRows, cmp);
        this.iterator = this.sortedRows.iterator();
        this.row = 0;
    }

    public List<String> getResultVars() {
        return this.resultVars;
    }

    public int getRowNumber() {
        return this.row;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public boolean isOrdered() {
        return true;
    }

    public QuerySolution next() {
        return this.nextSolution();
    }

    public Binding nextBinding() {
        return this.iterator.next();
    }

    public QuerySolution nextSolution() {
        return new ResultBinding(null, this.nextBinding());
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.sortedRows.toString();
    }

    public Model getResourceModel() {
        return null;
    }
}

