/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib.tuple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;

public final class TupleMap {
    private final int[] getTransform;
    private final int[] putTransform;
    private final int len;
    private final String label;
    private static boolean CHECKING = true;

    public static TupleMap create(String input, String output) {
        return new TupleMap(input + "->" + output, TupleMap.compileMapping(input, output));
    }

    public static TupleMap create(String label, String input, String output) {
        return new TupleMap(label, TupleMap.compileMapping(input, output));
    }

    public static <T> TupleMap create(String label, List<T> input, List<T> output) {
        return new TupleMap(label, TupleMap.compileMapping(input, output));
    }

    public static <T> TupleMap create(String label, T[] input, T[] output) {
        return new TupleMap(label, TupleMap.compileMapping(input, output));
    }

    private TupleMap(String label, int ... elements) {
        this.len = elements.length;
        this.label = label;
        this.putTransform = new int[elements.length];
        Arrays.fill(this.putTransform, -1);
        this.getTransform = new int[elements.length];
        Arrays.fill(this.getTransform, -1);
        int i = 0;
        while (i < elements.length) {
            int x = elements[i];
            if (x < 0 || x >= elements.length) {
                throw new IllegalArgumentException("Out of range: " + x);
            }
            if (this.putTransform[i] != -1 || this.getTransform[x] != -1) {
                throw new IllegalArgumentException("Inconsistent: " + ListUtils.str(elements));
            }
            this.putTransform[i] = x;
            this.getTransform[x] = i++;
        }
    }

    private TupleMap(String label, int[] getTransform, int[] putTransform) {
        this.label = label;
        this.len = getTransform.length;
        this.getTransform = getTransform;
        this.putTransform = putTransform;
    }

    public TupleMap reverse() {
        return new TupleMap("Reverse:" + this.label, this.putTransform, this.getTransform);
    }

    public int length() {
        return this.len;
    }

    public int getSlotIdx(int idx) {
        return this.getTransform[idx];
    }

    public int putSlotIdx(int idx) {
        return this.putTransform[idx];
    }

    public int mapIdx(int idx) {
        return this.getSlotIdx(idx);
    }

    public int unmapIdx(int idx) {
        return this.putSlotIdx(idx);
    }

    public <T> Tuple<T> map(Tuple<T> src) {
        return TupleMap.apply(src, this.getTransform);
    }

    public <T> Tuple<T> unmap(Tuple<T> src) {
        return TupleMap.apply(src, this.putTransform);
    }

    public <T> T[] map(T[] src, T[] dst) {
        if (src == dst) {
            throw new IllegalArgumentException("Source and destination are the same array");
        }
        this.applyArray(src, dst, this.getTransform);
        return dst;
    }

    public <T> T[] unmap(T[] src, T[] dst) {
        if (src == dst) {
            throw new IllegalArgumentException("Source and destination are the same array");
        }
        this.applyArray(src, dst, this.putTransform);
        return dst;
    }

    private static <T> Tuple<T> apply(Tuple<T> src, int[] getTransform) {
        if (src.len() != getTransform.length) {
            throw new IllegalArgumentException("Lengths do not match: Tuple:" + src.len() + "; transform:" + getTransform.length);
        }
        Object[] elts = new Object[src.len()];
        for (int i = 0; i < src.len(); ++i) {
            int j = getTransform[i];
            elts[i] = src.get(j);
        }
        return TupleFactory.tuple(elts);
    }

    private <T> void applyArray(T[] src, T[] dst, int[] transform) {
        for (int i = 0; i < src.length; ++i) {
            int j = transform[i];
            dst[i] = src[j];
        }
    }

    public <T> T mapSlot(int idx, Tuple<T> tuple) {
        this.checkLength(tuple);
        idx = this.getSlotIdx(idx);
        return tuple.get(idx);
    }

    public <T> T unmapSlot(int idx, Tuple<T> tuple) {
        this.checkLength(tuple);
        idx = this.putSlotIdx(idx);
        return tuple.get(idx);
    }

    public <T> T mapSlot(int idx, T[] tuple) {
        return tuple[this.getSlotIdx(idx)];
    }

    public <T> T unmapSlot(int idx, T[] tuple) {
        return tuple[this.putSlotIdx(idx)];
    }

    private static int[] compileMapping(String domain, String range) {
        List<Character> input = StrUtils.toCharList(domain);
        List<Character> output = StrUtils.toCharList(range);
        return TupleMap.compileMapping(input, output);
    }

    private static <T> int[] compileMapping(T[] domain, T[] range) {
        return TupleMap.compileMapping(Arrays.asList(domain), Arrays.asList(range));
    }

    private static <T> int[] compileMapping(List<T> domain, List<T> range) {
        if (domain.size() != range.size()) {
            throw new AtlasException("Bad mapping: lengths not the same: " + domain + " -> " + range);
        }
        int[] cols = new int[domain.size()];
        boolean[] mapped = new boolean[domain.size()];
        for (int i = 0; i < domain.size(); ++i) {
            T input = domain.get(i);
            int j = range.indexOf(input);
            if (j < 0) {
                throw new AtlasException("Bad mapping: missing mapping: " + domain + " -> " + range);
            }
            if (mapped[j]) {
                throw new AtlasException("Bad mapping: duplicate: " + domain + " -> " + range);
            }
            cols[i] = j;
            mapped[j] = true;
        }
        return cols;
    }

    List<Integer> transformGet() {
        return this.arrayToList(this.getTransform);
    }

    List<Integer> transformPut() {
        return this.arrayToList(this.putTransform);
    }

    private List<Integer> arrayToList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        for (int x : array) {
            list.add(x);
        }
        return Collections.unmodifiableList(list);
    }

    public boolean sameMapping(TupleMap other) {
        return Arrays.equals(this.getTransform, other.getTransform);
    }

    public String toString() {
        return String.format("%s:%s:%s", this.label, this.mapStr(this.putTransform, "->"), this.mapStr(this.getTransform, "<-"));
    }

    private Object mapStr(int[] map, String arrow) {
        StringBuilder buff = new StringBuilder();
        String sep = "{";
        for (int i = 0; i < map.length; ++i) {
            buff.append(sep);
            sep = ", ";
            buff.append(String.format("%d%s%d", i, arrow, map[i]));
        }
        buff.append("}");
        return buff.toString();
    }

    public String getLabel() {
        return this.label;
    }

    private final void checkLength(Tuple<?> tuple) {
        if (CHECKING && tuple.len() != this.length()) {
            throw new IllegalArgumentException("Tuple length " + tuple.len() + ": not of length " + this.length());
        }
    }
}

