/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BinarySet<T>
extends AbstractSet<T> {
    private T first;
    private T second;

    private BinarySet(T first, T second) {
        if (first.equals(second)) {
            throw new IllegalArgumentException("Cannot create a binary set with single element: " + first);
        }
        this.first = first;
        this.second = second;
    }

    public static <T> BinarySet<T> create(T first, T second) {
        return new BinarySet<T>(first, second);
    }

    public T first() {
        return this.first;
    }

    public T second() {
        return this.second;
    }

    @Override
    public boolean contains(Object o) {
        return this.first.equals(o) || this.second.equals(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 2;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.i++ == 0 ? BinarySet.this.first : BinarySet.this.second;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return 2;
    }
}

