/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.tbox.impl.UnaryTBox;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.BinarySet;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public class BinaryTBox {
    public static final Logger log = Logger.getLogger(UnaryTBox.class.getName());
    private Map<BinarySet<ATermAppl>, Unfolding> unfoldings = CollectionUtils.makeMap();
    private Map<ATermAppl, List<Unfolding>> conditionalUnfoldings = CollectionUtils.makeIdentityMap();

    public void add(BinarySet<ATermAppl> set, ATermAppl result, Set<ATermAppl> explanation) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Add sub: (" + ATermUtils.toString(set.first()) + ", " + ATermUtils.toString(set.second()) + ") < " + ATermUtils.toString(result));
        }
        result = ATermUtils.normalize(result);
        this.unfoldings.put(set, Unfolding.create(result, explanation));
        this.addUnfolding(set.first(), set.second(), result, explanation);
        this.addUnfolding(set.second(), set.first(), result, explanation);
    }

    private void addUnfolding(ATermAppl c, ATermAppl condition, ATermAppl result, Set<ATermAppl> explanation) {
        List<Unfolding> list = this.conditionalUnfoldings.get(c);
        if (list == null) {
            list = CollectionUtils.makeList();
            this.conditionalUnfoldings.put(c, list);
        }
        list.add(Unfolding.create(result, condition, explanation));
    }

    public Unfolding unfold(BinarySet<ATermAppl> set) {
        return this.unfoldings.get(set);
    }

    public Iterator<Unfolding> unfold(ATermAppl concept) {
        List<Unfolding> unfoldingList = this.conditionalUnfoldings.get(concept);
        return unfoldingList == null ? IteratorUtils.emptyIterator() : unfoldingList.iterator();
    }

    public boolean contains(ATermAppl concept) {
        return this.conditionalUnfoldings.containsKey(concept);
    }

    public void print(Appendable out) throws IOException {
        for (Map.Entry<BinarySet<ATermAppl>, Unfolding> e : this.unfoldings.entrySet()) {
            BinarySet<ATermAppl> set = e.getKey();
            out.append("(");
            out.append(ATermUtils.toString(set.first()));
            out.append(",");
            out.append(ATermUtils.toString(set.second()));
            out.append(") < ");
            out.append(e.getValue().toString());
            out.append("\n");
        }
    }
}

