/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import com.clarkparsia.pellet.datatypes.FloatingPointType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class FloatingPointInterval<T extends Number> {
    private static final Logger log = Logger.getLogger(FloatingPointInterval.class.getCanonicalName());
    private final T lower;
    private final FloatingPointType<T> type;
    private final T upper;

    public static <U extends Number> FloatingPointInterval<U> unconstrained(FloatingPointType<U> type) {
        return new FloatingPointInterval<U>(type, type.getNegativeInfinity(), type.getPositiveInfinity());
    }

    public FloatingPointInterval(FloatingPointType<T> type, T point) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (point == null) {
            throw new NullPointerException();
        }
        if (type.isNaN(point)) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.lower = point;
        this.upper = point;
    }

    public FloatingPointInterval(FloatingPointType<T> type, T lower, T upper) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (lower == null) {
            throw new NullPointerException();
        }
        if (upper == null) {
            throw new NullPointerException();
        }
        if (type.isNaN(lower)) {
            throw new IllegalArgumentException();
        }
        if (type.isNaN(upper)) {
            throw new IllegalArgumentException();
        }
        int cmp = ((Comparable)lower).compareTo(upper);
        if (cmp > 0) {
            String msg = String.format("Lower bound of interval (%s) should not be greater than upper bound of interval (%s)", lower, upper);
            log.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.type = type;
        this.lower = lower;
        this.upper = upper;
    }

    public boolean canUnionWith(FloatingPointInterval<T> other) {
        int ll = ((Comparable)this.lower).compareTo(other.lower);
        int uu = ((Comparable)this.upper).compareTo(other.upper);
        if (ll <= 0) {
            if (uu < 0) {
                if (((Comparable)this.upper).compareTo(other.lower) < 0) {
                    return this.type.increment(this.upper).equals(other.lower);
                }
                return true;
            }
            return true;
        }
        if (uu > 0) {
            if (((Comparable)this.lower).compareTo(other.upper) > 0) {
                return this.type.increment(other.upper).equals(this.lower);
            }
            return true;
        }
        return true;
    }

    public boolean contains(T n) {
        if (this.type.isNaN(n)) {
            return false;
        }
        int lcmp = ((Comparable)this.getLower()).compareTo(n);
        if (lcmp > 0) {
            return false;
        }
        if (lcmp == 0) {
            return true;
        }
        int ucmp = ((Comparable)this.getUpper()).compareTo(n);
        return ucmp >= 0;
    }

    private FloatingPointInterval<T> create(T lower, T upper) {
        return new FloatingPointInterval<T>(this.type, lower, upper);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatingPointInterval other = (FloatingPointInterval)obj;
        if (!this.lower.equals(other.lower)) {
            return false;
        }
        return this.upper.equals(other.upper);
    }

    public T getLower() {
        return this.lower;
    }

    public T getUpper() {
        return this.upper;
    }

    public FloatingPointInterval<T> greater(T n) {
        if (n == null) {
            throw new NullPointerException();
        }
        if (this.type.isNaN(n)) {
            throw new IllegalArgumentException();
        }
        if (((Comparable)this.getLower()).compareTo(n) >= 0) {
            return this;
        }
        if (((Comparable)this.getUpper()).compareTo(n) <= 0) {
            return null;
        }
        return this.create(this.type.increment(n), this.getUpper());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.lower == null ? 0 : this.lower.hashCode());
        result = 31 * result + (this.upper == null ? 0 : this.upper.hashCode());
        return result;
    }

    public FloatingPointInterval<T> intersection(FloatingPointInterval<T> that) {
        int ll = ((Comparable)this.lower).compareTo(that.lower);
        int uu = ((Comparable)this.upper).compareTo(that.upper);
        if (ll <= 0) {
            if (uu < 0) {
                if (((Comparable)this.upper).compareTo(that.lower) < 0) {
                    return null;
                }
                return this.create(that.lower, this.upper);
            }
            return that;
        }
        if (uu > 0) {
            if (((Comparable)this.lower).compareTo(that.upper) > 0) {
                return null;
            }
            return this.create(this.lower, that.upper);
        }
        return this;
    }

    public FloatingPointInterval<T> less(T n) {
        if (n == null) {
            throw new NullPointerException();
        }
        if (this.type.isNaN(n)) {
            throw new IllegalArgumentException();
        }
        if (((Comparable)this.getUpper()).compareTo(n) <= 0) {
            return this;
        }
        if (((Comparable)this.getLower()).compareTo(n) >= 0) {
            return null;
        }
        return this.create(this.getLower(), this.type.decrement(n));
    }

    public List<FloatingPointInterval<T>> remove(FloatingPointInterval<T> other) {
        Object after;
        FloatingPointInterval<T> before;
        int ll = ((Comparable)this.lower).compareTo(other.lower);
        int lu = ((Comparable)this.lower).compareTo(other.upper);
        int ul = ((Comparable)this.upper).compareTo(other.lower);
        int uu = ((Comparable)this.upper).compareTo(other.upper);
        if (ll < 0) {
            if (ul < 0) {
                before = this;
                after = null;
            } else {
                T f = this.type.decrement(other.lower);
                before = f.equals(this.type.getNegativeInfinity()) ? null : this.create(this.lower, f);
                after = uu <= 0 ? null : ((f = this.type.increment(other.upper)).equals(this.type.getPositiveInfinity()) ? null : super.create(this.type.increment(other.upper), this.upper));
            }
        } else if (lu > 0) {
            before = null;
            after = this;
        } else if (uu <= 0) {
            before = null;
            after = null;
        } else {
            before = null;
            T f = this.type.increment(other.upper);
            after = f.equals(this.type.getPositiveInfinity()) ? super.create(this.type.increment(other.upper), this.upper) : null;
        }
        if (before == null) {
            if (after == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(after);
        }
        if (after == null) {
            return Collections.singletonList(before);
        }
        return Arrays.asList(before, after);
    }

    public Number size() {
        return this.type.intervalSize(this.lower, this.upper);
    }

    public List<FloatingPointInterval<T>> union(FloatingPointInterval<T> other) {
        FloatingPointInterval<T> second;
        FloatingPointInterval<T> first;
        int ll = ((Comparable)this.lower).compareTo(other.lower);
        int lu = ((Comparable)this.lower).compareTo(other.upper);
        int ul = ((Comparable)this.upper).compareTo(other.lower);
        int uu = ((Comparable)this.upper).compareTo(other.upper);
        if (ll < 0) {
            if (ul < 0) {
                first = this;
                second = other;
            } else {
                second = null;
                first = uu < 0 ? super.create(this.lower, other.upper) : this;
            }
        } else if (lu > 0) {
            first = other;
            second = this;
        } else {
            second = null;
            first = uu <= 0 ? other : super.create(other.lower, this.upper);
        }
        if (first == null) {
            if (second == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(second);
        }
        if (second == null) {
            return Collections.singletonList(first);
        }
        return Arrays.asList(first, second);
    }

    public Iterator<T> valueIterator() {
        return new ValueIterator(this, this.lower, this.upper);
    }

    public static class ValueIterator
    implements Iterator<T> {
        private final T last;
        private T next;
        final /* synthetic */ FloatingPointInterval this$0;

        public ValueIterator(T lower, T upper) {
            this.this$0 = this$0;
            if (lower == null) {
                throw new NullPointerException();
            }
            if (upper == null) {
                throw new NullPointerException();
            }
            this.next = lower;
            this.last = upper;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            Object ret = this.next;
            this.next = this.next.equals(this.last) ? null : this.this$0.type.increment(this.next);
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

