/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.blocking;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tableau.blocking.Block1;
import org.mindswap.pellet.tableau.blocking.Block2;
import org.mindswap.pellet.tableau.blocking.Block3;
import org.mindswap.pellet.tableau.blocking.Block4;
import org.mindswap.pellet.tableau.blocking.Block5;
import org.mindswap.pellet.tableau.blocking.Block6;
import org.mindswap.pellet.tableau.blocking.BlockingCondition;
import org.mindswap.pellet.tableau.blocking.BlockingContext;
import org.mindswap.pellet.utils.Timer;

public abstract class Blocking {
    public static final Logger log = Logger.getLogger(Blocking.class.getName());
    protected static final BlockingCondition block1 = new Block1();
    protected static final BlockingCondition block2 = new Block2();
    protected static final BlockingCondition block3 = new Block3();
    protected static final BlockingCondition block4 = new Block4();
    protected static final BlockingCondition block5 = new Block5();
    protected static final BlockingCondition block6 = new Block6();

    protected Blocking() {
    }

    public boolean isDynamic() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlocked(Individual blocked) {
        Timer t = blocked.getABox().getKB().timers.startTimer("blocking");
        try {
            boolean bl = !blocked.isRoot() && (this.isIndirectlyBlocked(blocked) || this.isDirectlyBlockedInt(blocked));
            return bl;
        }
        finally {
            t.stop();
        }
    }

    public boolean isIndirectlyBlocked(Individual blocked) {
        Individual parent = blocked.getParent();
        if (parent == null) {
            return false;
        }
        blocked.setBlocked(this.isBlocked(parent));
        return blocked.isBlocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectlyBlocked(Individual blocked) {
        Timer t = blocked.getABox().getKB().timers.startTimer("dBlocking");
        try {
            boolean bl = this.isDirectlyBlockedInt(blocked);
            return bl;
        }
        finally {
            t.stop();
        }
    }

    protected boolean isDirectlyBlockedInt(Individual blocked) {
        Individual parentBlocked = blocked.getParent();
        if (blocked.isRoot() || parentBlocked.isRoot()) {
            return false;
        }
        BlockingContext cxt = new BlockingContext(blocked);
        while (cxt.moveBlockerUp()) {
            if (!this.isDirectlyBlockedBy(cxt)) continue;
            blocked.setBlocked(true);
            if (log.isLoggable(Level.FINER)) {
                log.finer(blocked + " blocked by " + cxt.blocker);
            }
            return true;
        }
        if (PelletOptions.USE_ANYWHERE_BLOCKING) {
            assert (cxt.blocker.isRoot());
            return this.isDirectlyBlockedByDescendant(cxt);
        }
        return false;
    }

    protected boolean isDirectlyBlockedByDescendant(BlockingContext cxt) {
        if (cxt.blocked.getParent().equals(cxt.blocker)) {
            return false;
        }
        if (!cxt.blocker.isRoot() && this.isDirectlyBlockedBy(cxt)) {
            cxt.blocked.setBlocked(true);
            if (log.isLoggable(Level.FINER)) {
                log.finer(cxt.blocked + " blocked by " + cxt.blocker);
            }
            return true;
        }
        Individual blocker = cxt.blocker;
        for (Edge e : blocker.getOutEdges()) {
            Node child = e.getTo();
            if (!cxt.moveBlockerDown(child)) continue;
            if (this.isDirectlyBlockedByDescendant(cxt)) {
                return true;
            }
            cxt.moveBlockerUp();
        }
        return false;
    }

    protected abstract boolean isDirectlyBlockedBy(BlockingContext var1);
}

