/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DeltaMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, V> base;
    private final Map<K, V> additions = Maps.newHashMap();
    private final Map<K, V> removals = Maps.newHashMap();
    private int size;

    public DeltaMap(Map<K, V> base) {
        this.base = base;
        this.size = base.size();
    }

    public void reset() {
        this.additions.clear();
        this.removals.clear();
        this.size = this.base.size();
    }

    public Map<K, V> getAdditions() {
        return this.additions;
    }

    public Map<K, V> getRemovals() {
        return this.removals;
    }

    @Override
    public void clear() {
        this.additions.clear();
        this.removals.putAll(this.base);
        this.size = 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.additions.containsKey(key) || !this.removals.containsKey(key) && this.base.containsKey(key);
    }

    @Override
    public V get(Object key) {
        V result = this.additions.get(key);
        if (result == null && !this.removals.containsKey(key)) {
            result = this.base.get(key);
        }
        return result;
    }

    @Override
    public V put(K key, V value) {
        V result = this.additions.put(key, value);
        if (result == null && this.removals.remove(key) == null) {
            result = this.base.get(key);
        }
        if (result == null) {
            ++this.size;
        }
        return result;
    }

    @Override
    public V remove(Object e) {
        V result = this.additions.remove(e);
        if (result == null && (result = this.base.get(e)) != null) {
            this.removals.put(e, result);
        }
        if (result != null) {
            --this.size;
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                Object result = DeltaMap.this.base.entrySet().iterator();
                if (!DeltaMap.this.additions.isEmpty() || !DeltaMap.this.removals.isEmpty()) {
                    result = Iterators.filter(result, (Predicate)new Predicate<Map.Entry<K, V>>(){

                        public boolean apply(Map.Entry<K, V> theEntry) {
                            return !DeltaMap.this.additions.containsKey(theEntry.getKey()) && !DeltaMap.this.removals.containsKey(theEntry.getKey());
                        }
                    });
                }
                if (!DeltaMap.this.additions.isEmpty()) {
                    result = Iterators.concat((Iterator)result, DeltaMap.this.additions.entrySet().iterator());
                }
                return result;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = DeltaMap.this.get(key);
                return Objects.equals(e.getValue(), value);
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return DeltaMap.this.size;
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }
}

