/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.KosarajuStrongConnectivityInspector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.taxonomy.AbstractDefinitionOrder;

public class JGraphBasedDefinitionOrder
extends AbstractDefinitionOrder {
    private Map<ATermAppl, Set<ATermAppl>> equivalents;
    private DirectedGraph<ATermAppl, DefaultEdge> graph;

    public JGraphBasedDefinitionOrder(KnowledgeBase kb, Comparator<ATerm> comparator) {
        super(kb, comparator);
    }

    private Set<ATermAppl> createSet() {
        return this.comparator != null ? new TreeSet(this.comparator) : CollectionUtils.makeIdentitySet();
    }

    private Queue<ATermAppl> createQueue() {
        return this.comparator != null ? new PriorityQueue(10, this.comparator) : new LinkedList();
    }

    private boolean addEquivalent(ATermAppl key, ATermAppl value) {
        Set<ATermAppl> values = this.equivalents.get(key);
        if (values == null) {
            values = this.createSet();
            this.equivalents.put(key, values);
        }
        return values.add(value);
    }

    private Set<ATermAppl> getAllEquivalents(ATermAppl key) {
        Set<ATermAppl> values = this.equivalents.get(key);
        if (values != null) {
            values.add(key);
        } else {
            values = Collections.singleton(key);
        }
        return values;
    }

    private Set<ATermAppl> getEquivalents(ATermAppl key) {
        Set<ATermAppl> values = this.equivalents.get(key);
        return values != null ? values : Collections.emptySet();
    }

    @Override
    protected void initialize() {
        this.equivalents = CollectionUtils.makeIdentityMap();
        this.graph = new DefaultDirectedGraph(DefaultEdge.class);
        this.graph.addVertex((Object)TermFactory.TOP);
        for (ATermAppl c : this.kb.getClasses()) {
            this.graph.addVertex((Object)c);
        }
    }

    @Override
    protected void addUses(ATermAppl c, ATermAppl usedByC) {
        if (c.equals(TermFactory.TOP)) {
            this.addEquivalent(TermFactory.TOP, usedByC);
        } else if (!c.equals(usedByC)) {
            this.graph.addEdge((Object)c, (Object)usedByC);
        }
    }

    @Override
    protected Set<ATermAppl> computeCycles() {
        Set<ATermAppl> cyclicConcepts = CollectionUtils.makeIdentitySet();
        cyclicConcepts.addAll(this.getEquivalents(TermFactory.TOP));
        KosarajuStrongConnectivityInspector scInspector = new KosarajuStrongConnectivityInspector(this.graph);
        List sccList = scInspector.stronglyConnectedSets();
        for (Set scc : sccList) {
            if (scc.size() == 1) continue;
            cyclicConcepts.addAll(scc);
            this.collapseCycle(scc);
        }
        return cyclicConcepts;
    }

    private void collapseCycle(Set<ATermAppl> scc) {
        Iterator<ATermAppl> i = scc.iterator();
        ATermAppl rep = i.next();
        while (i.hasNext()) {
            ATermAppl node = i.next();
            this.addEquivalent(rep, node);
            for (DefaultEdge edge : this.graph.incomingEdgesOf((Object)node)) {
                ATermAppl incoming = (ATermAppl)this.graph.getEdgeSource((Object)edge);
                if (incoming.equals(rep)) continue;
                this.graph.addEdge((Object)incoming, (Object)rep);
            }
            for (DefaultEdge edge : this.graph.outgoingEdgesOf((Object)node)) {
                ATermAppl outgoing = (ATermAppl)this.graph.getEdgeTarget((Object)edge);
                if (outgoing.equals(rep)) continue;
                this.graph.addEdge((Object)rep, (Object)outgoing);
            }
            this.graph.removeVertex((Object)node);
        }
    }

    @Override
    protected List<ATermAppl> computeDefinitionOrder() {
        List<ATermAppl> definitionOrder = CollectionUtils.makeList();
        definitionOrder.add(TermFactory.TOP);
        definitionOrder.addAll(this.getEquivalents(TermFactory.TOP));
        this.graph.removeVertex((Object)TermFactory.TOP);
        this.destructiveTopologocialSort(definitionOrder);
        definitionOrder.add(TermFactory.BOTTOM);
        return definitionOrder;
    }

    public void destructiveTopologocialSort(List<ATermAppl> nodesSorted) {
        Queue<ATermAppl> nodesPending = this.createQueue();
        for (ATermAppl node : this.graph.vertexSet()) {
            if (this.graph.outDegreeOf((Object)node) != 0) continue;
            nodesPending.add(node);
        }
        while (!nodesPending.isEmpty()) {
            ATermAppl node = nodesPending.remove();
            assert (this.graph.outDegreeOf((Object)node) == 0);
            nodesSorted.addAll(this.getAllEquivalents(node));
            for (DefaultEdge edge : this.graph.incomingEdgesOf((Object)node)) {
                ATermAppl source = (ATermAppl)this.graph.getEdgeSource((Object)edge);
                if (this.graph.outDegreeOf((Object)source) != 1) continue;
                nodesPending.add(source);
            }
            this.graph.removeVertex((Object)node);
        }
        assert (this.graph.vertexSet().isEmpty()) : "Failed to sort elements: " + this.graph.vertexSet();
    }
}

