/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.utils;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.Datatypes;
import com.clarkparsia.pellet.datatypes.Facet;
import java.net.URI;
import org.mindswap.pellet.utils.ATermUtils;

public class TermFactory {
    public static final ATermAppl TOP = ATermUtils.TOP;
    public static final ATermAppl BOTTOM = ATermUtils.BOTTOM;
    public static final ATermAppl TOP_LIT = ATermUtils.TOP_LIT;
    public static final ATermAppl BOTTOM_LIT = ATermUtils.BOTTOM_LIT;
    public static final ATermAppl TOP_DATA_PROPERTY = ATermUtils.TOP_DATA_PROPERTY;
    public static final ATermAppl BOTTOM_DATA_PROPERTY = ATermUtils.BOTTOM_DATA_PROPERTY;
    public static final ATermAppl TOP_OBJECT_PROPERTY = ATermUtils.TOP_OBJECT_PROPERTY;
    public static final ATermAppl BOTTOM_OBJECT_PROPERTY = ATermUtils.BOTTOM_OBJECT_PROPERTY;

    public static ATermAppl term(String name) {
        return ATermUtils.makeTermAppl(name);
    }

    public static ATermAppl bnode(String anonID) {
        return ATermUtils.makeBnode(anonID);
    }

    public static ATermAppl var(String name) {
        return ATermUtils.makeVar(name);
    }

    public static ATermList list(ATermAppl ... args) {
        return ATermUtils.makeList((ATerm[])args);
    }

    public static ATermAppl not(ATermAppl c) {
        return ATermUtils.makeNot((ATerm)c);
    }

    public static ATermAppl all(ATermAppl r, ATermAppl c) {
        return ATermUtils.makeAllValues((ATerm)r, (ATerm)c);
    }

    public static ATermAppl some(ATermAppl r, ATermAppl c) {
        return ATermUtils.makeSomeValues((ATerm)r, (ATerm)c);
    }

    public static ATermAppl min(ATermAppl r, int n, ATermAppl c) {
        return ATermUtils.makeMin((ATerm)r, n, (ATerm)c);
    }

    public static ATermAppl max(ATermAppl r, int n, ATermAppl c) {
        return ATermUtils.makeMax((ATerm)r, n, (ATerm)c);
    }

    public static ATermAppl card(ATermAppl r, int n, ATermAppl c) {
        return ATermUtils.makeCard((ATerm)r, n, (ATerm)c);
    }

    public static ATermAppl inv(ATermAppl r) {
        return ATermUtils.makeInv(r);
    }

    public static ATermAppl literal(boolean value) {
        return ATermUtils.makeTypedLiteral(value ? "true" : "false", Datatypes.BOOLEAN);
    }

    public static ATermAppl literal(byte value) {
        return ATermUtils.makeTypedLiteral(String.valueOf(value), Datatypes.BYTE);
    }

    public static ATermAppl literal(short value) {
        return ATermUtils.makeTypedLiteral(String.valueOf(value), Datatypes.SHORT);
    }

    public static ATermAppl literal(long value) {
        return ATermUtils.makeTypedLiteral(String.valueOf(value), Datatypes.LONG);
    }

    public static ATermAppl literal(int value) {
        return ATermUtils.makeTypedLiteral(String.valueOf(value), Datatypes.INTEGER);
    }

    public static ATermAppl literal(float value) {
        return ATermUtils.makeTypedLiteral(String.valueOf(value), Datatypes.FLOAT);
    }

    public static ATermAppl literal(double value) {
        return ATermUtils.makeTypedLiteral(String.valueOf(value), Datatypes.DOUBLE);
    }

    public static ATermAppl literal(URI value) {
        return ATermUtils.makeTypedLiteral(String.valueOf(value), Datatypes.ANY_URI);
    }

    public static ATermAppl literal(String value) {
        return ATermUtils.makePlainLiteral(value);
    }

    public static ATermAppl literal(String value, String lang) {
        return ATermUtils.makePlainLiteral(value, lang);
    }

    public static ATermAppl literal(String value, ATermAppl datatype) {
        return ATermUtils.makeTypedLiteral(value, datatype);
    }

    @Deprecated
    public static ATermAppl plainLiteral(String value, String lang) {
        return ATermUtils.makePlainLiteral(value, lang);
    }

    public static ATermAppl typedLiteral(String value, ATermAppl dt) {
        return ATermUtils.makeTypedLiteral(value, dt);
    }

    public static ATermAppl typedLiteral(String value, String dt) {
        return ATermUtils.makeTypedLiteral(value, dt);
    }

    public static ATermAppl value(ATermAppl r) {
        return ATermUtils.makeValue((ATerm)r);
    }

    public static ATermAppl and(ATermAppl c1, ATermAppl c2) {
        return ATermUtils.makeAnd((ATerm)c1, (ATerm)c2);
    }

    public static ATermAppl and(ATermAppl ... c) {
        if (c.length == 1) {
            return c[0];
        }
        return ATermUtils.makeAnd(ATermUtils.makeList((ATerm[])c));
    }

    public static ATermAppl or(ATermAppl c1, ATermAppl c2) {
        return ATermUtils.makeOr(c1, c2);
    }

    public static ATermAppl or(ATermAppl ... c) {
        if (c.length == 1) {
            return c[0];
        }
        return ATermUtils.makeOr(ATermUtils.makeList((ATerm[])c));
    }

    public static ATermAppl hasValue(ATermAppl r, ATermAppl ind) {
        return ATermUtils.makeHasValue((ATerm)r, (ATerm)ind);
    }

    public static ATermAppl oneOf(ATermAppl ... terms) {
        ATermList list = ATermUtils.EMPTY_LIST;
        for (ATermAppl term : terms) {
            list = list.insert((ATerm)TermFactory.value(term));
        }
        return ATermUtils.makeOr(list);
    }

    public static ATermAppl self(ATermAppl p) {
        return ATermUtils.makeSelf(p);
    }

    public static ATermAppl minInclusive(ATermAppl facetValue) {
        return ATermUtils.makeFacetRestriction(Facet.XSD.MIN_INCLUSIVE.getName(), facetValue);
    }

    public static ATermAppl minExclusive(ATermAppl facetValue) {
        return ATermUtils.makeFacetRestriction(Facet.XSD.MIN_EXCLUSIVE.getName(), facetValue);
    }

    public static ATermAppl maxInclusive(ATermAppl facetValue) {
        return ATermUtils.makeFacetRestriction(Facet.XSD.MAX_INCLUSIVE.getName(), facetValue);
    }

    public static ATermAppl maxExclusive(ATermAppl facetValue) {
        return ATermUtils.makeFacetRestriction(Facet.XSD.MAX_EXCLUSIVE.getName(), facetValue);
    }

    public static ATermAppl minLength(ATermAppl facetValue) {
        return ATermUtils.makeFacetRestriction(Facet.XSD.MIN_LENGTH.getName(), facetValue);
    }

    public static ATermAppl maxLength(ATermAppl facetValue) {
        return ATermUtils.makeFacetRestriction(Facet.XSD.MAX_LENGTH.getName(), facetValue);
    }

    public static ATermAppl length(ATermAppl facetValue) {
        return ATermUtils.makeFacetRestriction(Facet.XSD.LENGTH.getName(), facetValue);
    }

    public static ATermAppl pattern(ATermAppl facetValue) {
        return ATermUtils.makeFacetRestriction(Facet.XSD.PATTERN.getName(), facetValue);
    }

    public static ATermAppl restrict(ATermAppl baseDatatype, ATermAppl ... restrictions) {
        return ATermUtils.makeRestrictedDatatype(baseDatatype, restrictions);
    }
}

