/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.text.DecimalFormat;

public class MemUtils {
    private static final Runtime runtime = Runtime.getRuntime();
    public static final double BYTES_PER_MB = 1048576.0;
    private static final DecimalFormat MB_FORMAT = (DecimalFormat)DecimalFormat.getNumberInstance();

    public static void runGC() {
        try {
            for (int r = 0; r < 4; ++r) {
                MemUtils._runGC();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void _runGC() throws Exception {
        long usedMem1 = MemUtils.usedMemory();
        long usedMem2 = Long.MAX_VALUE;
        for (int i = 0; usedMem1 < usedMem2 && i < 500; ++i) {
            runtime.runFinalization();
            runtime.gc();
            Thread.yield();
            usedMem2 = usedMem1;
            usedMem1 = MemUtils.usedMemory();
        }
    }

    public static long usedMemoryAfterGC() {
        MemUtils.runGC();
        return MemUtils.usedMemory();
    }

    public static long usedMemory() {
        return runtime.totalMemory() - runtime.freeMemory();
    }

    public static long freeMemory() {
        return runtime.freeMemory();
    }

    public static long totalMemory() {
        return runtime.totalMemory();
    }

    public static double mb(long bytes) {
        return (double)bytes / 1048576.0;
    }

    public static void printUsedMemory(String msg) {
        System.out.println(msg + " " + MB_FORMAT.format(MemUtils.mb(MemUtils.usedMemory())) + "mb");
    }

    public static void printMemory(String msg, long mem) {
        System.out.println(msg + " " + MB_FORMAT.format(MemUtils.mb(mem)) + "mb");
    }

    static {
        MB_FORMAT.setMaximumFractionDigits(2);
    }
}

